/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.calendar.CalendarEvent;
import tecgraf.javautils.gui.calendar.CalendarListener;

public class CalendarPanel
extends JPanel {
    private ArrayList<CalendarListener> listeners;
    private JPanel northPanel;
    private JLabel monthYearLabel;
    private JPanel bodyPanel;
    private Button nextYear;
    private Button previewYear;
    private Button nextMonth;
    private Button previewMonth;
    private ArrayList<DayOfMonth> days;
    private ArrayList<DayOfWeek> daysOfWeeks;
    private long selectedDate;
    private boolean currentMonthOnly;
    private Color titleBackground = new Color(53, 74, 124);
    private Color titleForeground = Color.WHITE;
    private Color actualMonthForeground = Color.BLACK;
    private Color otherMonthForeground = Color.LIGHT_GRAY;
    private Color calendarBackground = Color.WHITE;
    private JDialog dialog;
    private Long dialogValue;

    public CalendarPanel() {
        this((Locale)null);
    }

    public CalendarPanel(Locale locale) {
        super(new BorderLayout());
        this.listeners = new ArrayList();
        if (locale == null) {
            locale = LNG.getLocale();
        }
        this.setLocale(locale);
        this.currentMonthOnly = false;
        this.days = new ArrayList();
        this.daysOfWeeks = new ArrayList();
        this.updateBorder(this.titleBackground);
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getBodyPanel(), "Center");
        DateFormatSymbols dfs = new DateFormatSymbols(this.getLocale());
        String[] wds = dfs.getShortWeekdays();
        DayOfWeek dow = new DayOfWeek(wds[1]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[2]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[3]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[4]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[5]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[6]);
        this.daysOfWeeks.add(dow);
        dow = new DayOfWeek(wds[7]);
        this.daysOfWeeks.add(dow);
        for (DayOfWeek d : this.daysOfWeeks) {
            this.getBodyPanel().add(d);
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(System.currentTimeMillis());
        for (int i = 0; i < 42; ++i) {
            DayOfMonth day = new DayOfMonth();
            this.days.add(day);
            this.getBodyPanel().add(day);
        }
        this.setSelectedDate(System.currentTimeMillis());
    }

    private void updateBorder(Color color) {
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color));
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            this.updateNorthPanelBorder(this.titleForeground);
            this.northPanel.setBackground(this.titleBackground);
            this.northPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.anchor = 17;
            this.northPanel.add((Component)this.getPreviewYear(), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.northPanel.add((Component)this.getPreviewMonth(), gbc);
            gbc.weightx = 1000.0;
            gbc.fill = 2;
            gbc.anchor = 10;
            gbc.gridx = 2;
            this.northPanel.add((Component)this.getMonthYearLabel(), gbc);
            gbc.fill = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            gbc.gridx = 3;
            this.northPanel.add((Component)this.getNextMonth(), gbc);
            gbc.gridx = 4;
            gbc.weightx = 1.0;
            this.northPanel.add((Component)this.getNextYear(), gbc);
        }
        return this.northPanel;
    }

    private void updateNorthPanelBorder(Color color) {
        MatteBorder out = BorderFactory.createMatteBorder(0, 0, 1, 0, color);
        Border in = BorderFactory.createEmptyBorder(3, 3, 2, 3);
        this.northPanel.setBorder(BorderFactory.createCompoundBorder(out, in));
    }

    private JLabel getMonthYearLabel() {
        if (this.monthYearLabel == null) {
            this.monthYearLabel = new JLabel();
            this.monthYearLabel.setForeground(this.titleForeground);
            this.monthYearLabel.setHorizontalAlignment(0);
        }
        return this.monthYearLabel;
    }

    private JPanel getBodyPanel() {
        if (this.bodyPanel == null) {
            this.bodyPanel = new JPanel();
            this.bodyPanel.setLayout(new GridLayout(7, 7));
        }
        return this.bodyPanel;
    }

    private Button getNextMonth() {
        if (this.nextMonth == null) {
            this.nextMonth = new Button(ButtonsType.NEXTMONTH);
            this.nextMonth.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    CalendarPanel.this.nextMonth();
                }
            });
        }
        return this.nextMonth;
    }

    private Button getNextYear() {
        if (this.nextYear == null) {
            this.nextYear = new Button(ButtonsType.NEXTYEAR);
            this.nextYear.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    CalendarPanel.this.nextYear();
                }
            });
        }
        return this.nextYear;
    }

    private Button getPreviewMonth() {
        if (this.previewMonth == null) {
            this.previewMonth = new Button(ButtonsType.PREVIEWMONTH);
            this.previewMonth.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    CalendarPanel.this.previewMonth();
                }
            });
        }
        return this.previewMonth;
    }

    private Button getPreviewYear() {
        if (this.previewYear == null) {
            this.previewYear = new Button(ButtonsType.PREVIEWYEAR);
            this.previewYear.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    CalendarPanel.this.previewYear();
                }
            });
        }
        return this.previewYear;
    }

    public void previewYear() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        gc.add(1, -1);
        this.setSelectedDate(gc.getTimeInMillis());
    }

    public void nextYear() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        gc.add(1, 1);
        this.setSelectedDate(gc.getTimeInMillis());
    }

    public void nextMonth() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        gc.add(2, 1);
        this.setSelectedDate(gc.getTimeInMillis());
    }

    public void previewMonth() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        gc.add(2, -1);
        this.setSelectedDate(gc.getTimeInMillis());
    }

    public void setButtonsVisible(boolean visible) {
        this.getPreviewMonth().setVisible(visible);
        this.getPreviewYear().setVisible(visible);
        this.getNextMonth().setVisible(visible);
        this.getNextYear().setVisible(visible);
    }

    public boolean isButtonsVisible() {
        return this.getPreviewMonth().isVisible();
    }

    public boolean isCurrentMonthOnly() {
        return this.currentMonthOnly;
    }

    public long getSelectedDate() {
        return this.selectedDate;
    }

    private void repaintTitle() {
        this.getNorthPanel().repaint();
        for (DayOfWeek dow : this.daysOfWeeks) {
            dow.update();
        }
    }

    public void setCurrentMonthOnly(boolean currentMonthOnly) {
        this.currentMonthOnly = currentMonthOnly;
        this.updateCalendar();
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color titleBackground) {
        this.titleBackground = titleBackground;
        this.getNorthPanel().setBackground(titleBackground);
        this.updateBorder(titleBackground);
        this.repaintTitle();
        this.updateCalendar();
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setTitleForeground(Color titleForeground) {
        this.titleForeground = titleForeground;
        this.updateNorthPanelBorder(titleForeground);
        this.getMonthYearLabel().setForeground(titleForeground);
        this.repaintTitle();
    }

    public Color getActualMonthForeground() {
        return this.actualMonthForeground;
    }

    public void setActualMonthForeground(Color actualMonthForeground) {
        this.actualMonthForeground = actualMonthForeground;
        this.updateCalendar();
    }

    public Color getOtherMonthForeground() {
        return this.otherMonthForeground;
    }

    public void setOtherMonthForeground(Color otherMonthForeground) {
        this.otherMonthForeground = otherMonthForeground;
        this.updateCalendar();
    }

    public Color getCalendarBackground() {
        return this.calendarBackground;
    }

    public void setCalendarBackground(Color calendarBackground) {
        this.calendarBackground = calendarBackground;
        this.updateCalendar();
    }

    public void setSelectedDate(long date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        int actualMonth = gc.get(2);
        int actualYear = gc.get(1);
        gc.setTimeInMillis(date);
        boolean dateInSameMonth = gc.get(2) == actualMonth;
        boolean dateInSameYear = gc.get(1) == actualYear;
        this.selectedDate = date;
        this.updateCalendar();
        CalendarEvent event = new CalendarEvent(date, dateInSameMonth && dateInSameYear);
        this.fireCalendarListeners(event);
    }

    private void updateCalendar() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.selectedDate);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        long time = gc.getTimeInMillis();
        this.selectedDate = gc.getTimeInMillis();
        gc.set(5, 1);
        int dayofweek = gc.get(7);
        int less = 0;
        switch (dayofweek) {
            case 1: {
                less = 0;
                break;
            }
            case 2: {
                less = 1;
                break;
            }
            case 3: {
                less = 2;
                break;
            }
            case 4: {
                less = 3;
                break;
            }
            case 5: {
                less = 4;
                break;
            }
            case 6: {
                less = 5;
                break;
            }
            case 7: {
                less = 6;
            }
        }
        int currentMonth = gc.get(2);
        DateFormatSymbols dfs = new DateFormatSymbols(this.getLocale());
        String monthYear = dfs.getMonths()[currentMonth];
        monthYear = monthYear + " - " + gc.get(1);
        this.getMonthYearLabel().setText(monthYear);
        gc.add(5, -1 * less);
        for (int i = 0; i < 42; ++i) {
            DayVisible dayVisible = DayVisible.ACTUALMONTH;
            if (this.currentMonthOnly) {
                if (gc.get(2) != currentMonth) {
                    dayVisible = DayVisible.OFF;
                }
            } else if (gc.get(2) != currentMonth) {
                dayVisible = DayVisible.OTHERMONTH;
            }
            DayOfMonth day = this.days.get(i);
            day.setDate(gc.getTimeInMillis(), dayVisible);
            if (this.compare(time, gc.getTimeInMillis())) {
                day.setSelected(true);
            } else {
                day.setSelected(false);
            }
            gc.add(5, 1);
        }
    }

    private boolean compare(long time1, long time2) {
        GregorianCalendar gc1 = new GregorianCalendar();
        GregorianCalendar gc2 = new GregorianCalendar();
        gc1.setTimeInMillis(time1);
        gc2.setTimeInMillis(time2);
        boolean day = gc1.get(5) == gc2.get(5);
        boolean month = gc1.get(2) == gc2.get(2);
        boolean year = gc1.get(1) == gc2.get(1);
        return day && month && year;
    }

    public Long showAsDialog(JFrame owner, String title, String confirmButtonTitle, String cancelButtonTitle, Component comp) {
        this.dialogValue = null;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        JPanel buttonPanel = new JPanel();
        JButton confirmButton = new JButton();
        confirmButton.setText(confirmButtonTitle);
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.dialogValue = CalendarPanel.this.selectedDate;
                CalendarPanel.this.dialog.dispose();
            }
        });
        buttonPanel.add(confirmButton);
        JButton cancelButton = null;
        if (cancelButtonTitle != null) {
            cancelButton = new JButton();
            cancelButton.setText(cancelButtonTitle);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarPanel.this.dialog.dispose();
                }
            });
            buttonPanel.add(cancelButton);
        }
        if (cancelButton != null) {
            JComponent[] buttons = new JButton[]{confirmButton, cancelButton};
            GUIUtils.matchPreferredSizes(buttons);
        }
        this.dialog = new JDialog(owner, title, true);
        this.dialog.setResizable(false);
        panel.add((Component)this, "Center");
        panel.add((Component)buttonPanel, "South");
        this.dialog.add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(comp);
        this.dialog.setVisible(true);
        return this.dialogValue;
    }

    public Long showAsDialog(JFrame owner, String title, Component comp) {
        this.dialogValue = null;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.dialog = new JDialog(owner, title, true);
        this.dialog.setResizable(false);
        panel.add((Component)this, "Center");
        this.dialog.add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(comp);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CalendarPanel.this.dialogValue = null;
            }
        });
        CalendarListener listener = new CalendarListener(){

            @Override
            public void dateSelected(CalendarEvent calendarEvent) {
                if (calendarEvent.isMonthChanged()) {
                    CalendarPanel.this.dialogValue = calendarEvent.getDate();
                    CalendarPanel.this.dialog.dispose();
                }
            }
        };
        this.addCalendarListener(listener);
        this.dialog.setVisible(true);
        this.removeCalendarListener(listener);
        return this.dialogValue;
    }

    private void fireCalendarListeners(CalendarEvent event) {
        for (CalendarListener listener : this.listeners) {
            listener.dateSelected(event);
        }
    }

    public void addCalendarListener(CalendarListener listener) {
        this.listeners.add(listener);
    }

    public void removeCalendarListener(CalendarListener listener) {
        this.listeners.remove(listener);
    }

    class DayOfMonth
    extends JPanel {
        private JLabel label;
        private long time;
        private boolean selected;
        private DayVisible dayVisible;

        public DayOfMonth() {
            super(new BorderLayout());
            this.label = new JLabel();
            this.add(this.label);
            MouseAdapter a = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    if (DayOfMonth.this.dayVisible != DayVisible.OFF) {
                        CalendarPanel.this.setSelectedDate(DayOfMonth.this.getTime());
                    }
                }
            };
            this.label.addMouseListener(a);
            this.addMouseListener(a);
        }

        public void setDate(long time, DayVisible dayVisible) {
            this.time = time;
            this.dayVisible = dayVisible;
            this.update();
        }

        private void update() {
            this.setBackground(CalendarPanel.this.calendarBackground);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(this.time);
            int day = gc.get(5);
            this.label.setText(Integer.toString(day));
            this.label.setHorizontalAlignment(0);
            if (this.dayVisible == DayVisible.ACTUALMONTH) {
                this.label.setForeground(CalendarPanel.this.actualMonthForeground);
            } else if (this.dayVisible == DayVisible.OTHERMONTH) {
                this.label.setForeground(CalendarPanel.this.otherMonthForeground);
            } else {
                this.label.setForeground(CalendarPanel.this.calendarBackground);
            }
            Border border = null;
            if (this.selected) {
                Border out = BorderFactory.createEmptyBorder(2, 2, 2, 2);
                MatteBorder in = BorderFactory.createMatteBorder(2, 2, 2, 2, CalendarPanel.this.titleBackground);
                border = BorderFactory.createCompoundBorder(out, in);
                border = BorderFactory.createCompoundBorder(out, border);
            } else {
                border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
            }
            this.setBorder(border);
        }

        public long getTime() {
            return this.time;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.update();
        }
    }

    class DayOfWeek
    extends JPanel {
        private JLabel label;

        public DayOfWeek(String name) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.label = new JLabel();
            this.label.setText(name);
            this.label.setHorizontalAlignment(0);
            this.add((Component)this.label, "Center");
            this.update();
        }

        public void update() {
            this.setBackground(CalendarPanel.this.titleBackground);
            this.label.setForeground(CalendarPanel.this.titleForeground);
        }
    }

    static enum DayVisible {
        ACTUALMONTH,
        OTHERMONTH,
        OFF;

    }

    class Button
    extends JPanel {
        private ButtonsType buttonsType;

        public Button(ButtonsType buttonsType) {
            this.buttonsType = buttonsType;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, 20);
        }

        @Override
        public void paint(Graphics g) {
            Polygon pol;
            g.setColor(CalendarPanel.this.titleBackground);
            Dimension dim = this.getSize();
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(CalendarPanel.this.titleForeground);
            int minHeight = 2 * dim.height / 10;
            int maxHieght = 8 * dim.height / 10;
            int width1 = 2 * dim.width / 16;
            int width2 = 8 * dim.width / 16;
            int width3 = 8 * dim.width / 16;
            int width4 = 14 * dim.width / 16;
            if (this.buttonsType == ButtonsType.PREVIEWMONTH || this.buttonsType == ButtonsType.PREVIEWYEAR) {
                pol = new Polygon();
                pol.addPoint(width1, dim.height / 2);
                pol.addPoint(width3, minHeight);
                pol.addPoint(width3, maxHieght);
                g.fillPolygon(pol);
            }
            if (this.buttonsType == ButtonsType.PREVIEWYEAR) {
                pol = new Polygon();
                pol.addPoint(width2, dim.height / 2);
                pol.addPoint(width4, minHeight);
                pol.addPoint(width4, maxHieght);
                g.fillPolygon(pol);
            }
            if (this.buttonsType == ButtonsType.NEXTMONTH || this.buttonsType == ButtonsType.NEXTYEAR) {
                pol = new Polygon();
                pol.addPoint(width3, dim.height / 2);
                pol.addPoint(width1, minHeight);
                pol.addPoint(width1, maxHieght);
                g.fillPolygon(pol);
            }
            if (this.buttonsType == ButtonsType.NEXTYEAR) {
                pol = new Polygon();
                pol.addPoint(width4, dim.height / 2);
                pol.addPoint(width2, minHeight);
                pol.addPoint(width2, maxHieght);
                g.fillPolygon(pol);
            }
        }
    }

    static enum ButtonsType {
        PREVIEWMONTH,
        PREVIEWYEAR,
        NEXTYEAR,
        NEXTMONTH;

    }
}

