/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;

class RegistrationTableRenderer<M, I>
implements TableCellRenderer {
    private static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private final IRegistrationDescriptor<M, I> descriptor;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        JLabel label = (JLabel)renderer;
        if (row < 0) {
            return label;
        }
        label.setFont(renderer.getFont());
        label.setOpaque(true);
        label.setIcon(null);
        label.setToolTipText(null);
        label.setHorizontalAlignment(0);
        if (isSelected) {
            label.setBackground(table.getSelectionBackground());
            label.setForeground(table.getSelectionForeground());
        } else {
            label.setForeground(table.getForeground());
            label.setBackground(table.getBackground());
        }
        Object object = table.getValueAt(row, col);
        this.descriptor.renderColumn(label, object, col, isSelected);
        if (!table.isEnabled()) {
            label.setForeground(Color.GRAY);
            label.setFont(label.getFont().deriveFont(2));
        }
        return renderer;
    }

    public RegistrationTableRenderer(IRegistrationDescriptor<M, I> descriptor) {
        this.descriptor = descriptor;
    }
}

