/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReportItem;

public class PrintableSeparator
implements PrintableReportItem {
    private Font font;
    private float height;
    private boolean changeFont;

    public PrintableSeparator(Font font) {
        this.font = font;
    }

    public PrintableSeparator(Font font, boolean changeFont) {
        this.font = font;
        this.changeFont = changeFont;
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        return this.printSeparator(g2, format);
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        return this.printSeparator(g2, format);
    }

    private boolean printSeparator(Graphics2D g2, PageFormat format) {
        this.height = g2.getFontMetrics(this.font).getHeight();
        return (double)this.height <= format.getImageableHeight();
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
        if (!this.changeFont) {
            return;
        }
        this.font = this.font.deriveFont((float)this.font.getSize() * configuration.getFontRate());
    }

    @Override
    public float getWidth() {
        return this.height;
    }
}

