/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import tecgraf.javautils.gui.table.IColumn;

public class ColumnsObjectTableModel<T>
extends AbstractTableModel {
    private List<T> rows;
    private IColumn<T>[] columns;

    public ColumnsObjectTableModel(List<T> rows, IColumn<T> ... columns) {
        if (rows == null) {
            throw new IllegalArgumentException("rows == null");
        }
        if (null == columns) {
            throw new IllegalArgumentException("columns == null");
        }
        if (columns.length == 0) {
            throw new IllegalArgumentException("columns.length == 0");
        }
        this.rows = rows;
        this.columns = columns;
    }

    public IColumn<T>[] getColumns() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T row = this.rows.get(rowIndex);
        if (null == row) {
            throw new NullPointerException("rowIndex points to a null object.");
        }
        return this.columns[columnIndex].getValue(row);
    }

    @Override
    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        T row = this.rows.get(rowIndex);
        if (null == row) {
            throw new NullPointerException("rowIndex points to a null object.");
        }
        this.columns[columnIndex].setValue(row, newValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        T row = this.rows.get(rowIndex);
        if (null == row) {
            throw new NullPointerException("rowIndex points to a null object.");
        }
        return this.columns[columnIndex].isEditable(row);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex].getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns[columnIndex].getColumnClass();
    }

    public void clear() {
        int size = this.rows.size();
        this.rows = new ArrayList<T>();
        if (size > 0) {
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public void setRows(List<T> newRows) {
        if (newRows == null) {
            throw new IllegalArgumentException("newRows == null");
        }
        this.rows = newRows;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void add(T row) {
        this.add(row, true);
    }

    private void add(T row, boolean notify) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index != -1) {
            this.rows.set(index, row);
            if (notify) {
                this.fireTableRowsUpdated(index, index);
            }
        } else {
            this.rows.add(row);
            if (notify) {
                index = this.rows.size() - 1;
                this.fireTableRowsInserted(index, index);
            }
        }
    }

    public void addAll(Collection<T> rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows == null");
        }
        for (T row : rows) {
            this.add(row, false);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean remove(T row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index == -1) {
            return false;
        }
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
        return true;
    }

    public T remove(int rowIndex) {
        T row = this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        return row;
    }

    public Collection<T> removeAll(int[] rowIndexes) {
        if (rowIndexes == null) {
            throw new IllegalArgumentException("rowIndexes == null");
        }
        ArrayList<T> removedRows = new ArrayList<T>();
        if (rowIndexes.length > 0) {
            int start = Integer.MAX_VALUE;
            int end = 0;
            for (int rowIndex : rowIndexes) {
                removedRows.add(this.rows.get(rowIndex));
                start = Math.min(start, rowIndex);
                end = Math.max(end, rowIndex);
            }
            this.rows.removeAll(removedRows);
            this.fireTableRowsDeleted(start, end);
        }
        return removedRows;
    }

    public Collection<T> removeAll() {
        List<T> allRows = this.getRows();
        this.clear();
        return allRows;
    }

    public boolean modify(T row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        int index = this.rows.indexOf(row);
        if (index == -1) {
            return false;
        }
        this.rows.set(index, row);
        this.fireTableRowsUpdated(index, index);
        return true;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public T getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public void swapRows(int index1, int index2) {
        Collections.swap(this.getRows(), index1, index2);
        this.fireTableDataChanged();
    }
}

