package textviewer.actions.core;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import textviewer.TextViewer;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.helper.application.AbstractApplicationAction;

/**
 * Ao de gravao do arquivo com um novo caminho
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class SaveAsAction extends
  AbstractApplicationAction<TextViewer> {

  /**
   * Busca o arquivo
   * 
   * @return o arquivo
   * @throws Exception em caso de erro.
   */
  abstract protected IFile selectFile() throws Exception;

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    final TextViewer textViewer = getApplication();
    final Window frame = textViewer.getApplicationFrame();
    try {
      final IFile file = selectFile();
      if (file == null) {
        return;
      }
      textViewer.saveFile(file);
    }
    catch (Exception e) {
      JOptionPane.showMessageDialog(frame, e, textViewer.getApplicationName(),
        JOptionPane.ERROR_MESSAGE);
    }
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao
   */
  public SaveAsAction(TextViewer textViewer) {
    super(textViewer);
  }
}
