/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import tecgraf.javautils.gui.print.PageSeparator;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReport;
import tecgraf.javautils.gui.print.PrintableReportItem;

public class DefaultPrintableReport
implements PrintableReport {
    private double verticalMargin;
    private double horizontalMargin;
    private int orientation;
    protected PrintableReportItem header;
    protected List<PrintableReportItem> printables;
    protected PrintableReportItem footer;
    private int currentPage;
    private int nextPrintable;
    private int oldLastPrinted;
    private boolean fullPrinted;
    private boolean oldFullPrinted;
    private PrintConfiguration configuration;

    public DefaultPrintableReport(List<PrintableReportItem> printables) {
        this.printables = printables;
        this.horizontalMargin = 2.5;
        this.verticalMargin = 1.5;
        this.orientation = 1;
        this.configuration = new PrintConfiguration();
    }

    @Override
    public void setHorizontalMargin(double horizontalMargin) {
        this.horizontalMargin = horizontalMargin;
    }

    @Override
    public void setVerticalMargin(double verticalMargin) {
        this.verticalMargin = verticalMargin;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setHeader(PrintableReportItem header) {
        this.header = header;
        if (header != null) {
            header.initPrinting(this.configuration);
        }
    }

    @Override
    public void setPrintables(List<PrintableReportItem> printables) {
        this.printables = printables;
        for (PrintableReportItem item : printables) {
            item.initPrinting(this.configuration);
        }
    }

    @Override
    public void setFooter(PrintableReportItem footer) {
        this.footer = footer;
        if (footer != null) {
            footer.initPrinting(this.configuration);
        }
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            this.oldLastPrinted = 0;
            this.currentPage = 0;
            this.oldFullPrinted = false;
        }
        if (pageIndex == this.currentPage) {
            this.nextPrintable = this.oldLastPrinted;
            this.fullPrinted = this.oldFullPrinted;
        }
        if (this.fullPrinted && this.nextPrintable >= this.printables.size() - 1) {
            return 1;
        }
        this.currentPage = pageIndex;
        this.oldLastPrinted = this.nextPrintable;
        this.oldFullPrinted = this.fullPrinted;
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(Color.BLACK);
        PageFormat printableFormat = (PageFormat)pageFormat.clone();
        if (this.header != null) {
            this.header.print(g2, printableFormat, pageIndex);
            this.adjustPrintable(printableFormat, this.header.getHeight(), true);
        }
        if (this.footer != null) {
            this.printFooter(g2, printableFormat, pageIndex, true);
        }
        for (int i = this.nextPrintable; i < this.printables.size(); ++i) {
            this.nextPrintable = i;
            PrintableReportItem printable = this.printables.get(i);
            g2.setColor(Color.BLACK);
            this.fullPrinted = printable.print(g2, printableFormat, pageIndex);
            if (!this.fullPrinted) break;
            if (this.adjustPrintable(printableFormat, printable.getHeight(), true)) continue;
            if (i + 1 >= this.printables.size()) break;
            this.nextPrintable = this.printables.get(i + 1) instanceof PageSeparator ? i + 2 : i + 1;
            break;
        }
        return 0;
    }

    protected void printFooter(Graphics2D g2, PageFormat format, int pageIndex, boolean print) {
        this.footer.simulatePrint(g2, format, pageIndex);
        double footerHeight = this.footer.getHeight();
        PageFormat footerFormat = (PageFormat)format.clone();
        Paper paper = footerFormat.getPaper();
        if (format.getOrientation() == 1) {
            paper.setImageableArea(paper.getImageableX(), paper.getImageableY() + paper.getImageableHeight() - footerHeight, paper.getImageableWidth(), footerHeight);
        } else if (format.getOrientation() == 0) {
            paper.setImageableArea(paper.getImageableX() + paper.getImageableWidth() - footerHeight, paper.getImageableY(), footerHeight, paper.getImageableHeight());
        }
        footerFormat.setPaper(paper);
        if (print) {
            this.footer.print(g2, footerFormat, pageIndex);
        }
        this.adjustPrintable(format, (float)footerHeight, false);
    }

    protected boolean adjustPrintable(PageFormat format, float printableHeight, boolean adjustY) {
        Paper paper = format.getPaper();
        double paperHeight = format.getOrientation() == 1 ? paper.getImageableHeight() : paper.getImageableWidth();
        double availableHeight = paperHeight - (double)printableHeight;
        if (availableHeight <= 0.1) {
            return false;
        }
        if (format.getOrientation() == 1) {
            paper.setImageableArea(paper.getImageableX(), paper.getImageableY() + (double)(adjustY ? printableHeight : 0.0f), paper.getImageableWidth(), paper.getImageableHeight() - (double)printableHeight);
        } else if (format.getOrientation() == 0) {
            paper.setImageableArea(paper.getImageableX() + (double)(adjustY ? printableHeight : 0.0f), paper.getImageableY(), paper.getImageableWidth() - (double)printableHeight, paper.getImageableHeight());
        }
        format.setPaper(paper);
        return true;
    }

    @Override
    public int getNumberOfPages() {
        return -1;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        double hMargin = this.horizontalMargin * 28.346456664;
        double vMargin = this.verticalMargin * 28.346456664;
        paper.setImageableArea(hMargin, vMargin, paper.getWidth() - 2.0 * hMargin, paper.getHeight() - 2.0 * vMargin);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(this.orientation);
        return PrinterJob.getPrinterJob().validatePage(pageFormat);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
        this.configuration = configuration;
        if (this.header != null) {
            this.header.initPrinting(configuration);
        }
        if (this.footer != null) {
            this.footer.initPrinting(configuration);
        }
        for (PrintableReportItem item : this.printables) {
            item.initPrinting(configuration);
        }
    }
}

