/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class MultiLineLabelHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private int verticalGap = 8;
    private int lineSpace = 2;

    public MultiLineLabelHeaderRenderer() {
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setTitle(table, (String)value);
        return this;
    }

    public void setTitle(JTable table, String title) {
        this.setFont(table.getFont());
        this.setText("<html><center>" + title.replaceAll("\n", "<br>") + "</center></html>");
        Insets insets = this.getInsets();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        String[] lines = title.split("\n");
        int width = 0;
        for (String aLine : lines) {
            width = Math.max(width, metrics.stringWidth(aLine));
        }
        int height = (metrics.getHeight() + this.lineSpace) * lines.length;
        width += insets.left + insets.right;
        height += this.verticalGap + insets.top + insets.bottom;
        Icon icon = this.getIcon();
        if (icon != null) {
            width += this.getIconTextGap() + this.getIcon().getIconWidth();
            height += Math.max(metrics.getHeight(), icon.getIconHeight()) - metrics.getHeight();
        }
        Dimension size = new Dimension(width, height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
    }

    public void setVerticalGap(int vertGap) {
        this.verticalGap = vertGap;
    }

    public void setLineSpace(int space) {
        this.lineSpace = space;
    }
}

