package csdk.v2.extras.context;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Informaes obtidas dos logs de eventos associados  um perdo de tempo e
 * busca especificos. No possuindo portanto dados para todos os tipos de
 * tabelas. Estes dados so obtidos conforme a demanda.
 * 
 * @author Tecgraf
 */
public interface ILogsInfo {

  /**
   * @return data de incio
   */
  public Date getStartDate();

  /**
   * @return data de trmino
   */
  public Date getEndDate();

  /**
   * @return informaes dos logins realizados no perodo associado.
   */
  public List<String[]> getLoginTable();

  /**
   * @return informaes das aplicaes utilizadas no perodo associado.
   */
  public List<String[]> getApplicationsTable();

  /**
   * @return informaes das execues realizadas no perodo associado.
   */
  public List<String[]> getExecutionsTable();

  /**
   * @return todas as aplicaes associadas aos dados da busca. Pode retornar um
   *         conjunto vazio, caso no existam dados de aplicaes.
   */
  public Set<String> getApplications();

  /**
   * @return todos os algoritmos associados aos dados da busca. Pode retornar um
   *         conjunto vazio, caso no existam dados de execues.
   */
  public Set<String> getAlgorithms();

  /**
   * Consulta um mapa com o nmero total de execues por usurios (chave).
   * Considera na pesquisa apenas as execues dos algoritmos fornecidos como
   * parmetro.
   * 
   * @param filterAlgorithms lista de algoritmos da qual se deseja obter os
   *        dados de execuo
   * 
   * @return mapa com nmero de execues por USURIO
   */
  public Map<String, Integer> getExecutionsByUser(List<String> filterAlgorithms);

  /**
   * Consulta um mapa com o nmero total de execues por algoritmos (chave).
   * Considera na pesquisa apenas as execues dos algoritmos fornecidos como
   * parmetro.
   * 
   * @param filterAlgorithms lista de algoritmos da qual se deseja obter os
   *        dados de execuo
   * 
   * @return mapa com nmero de execues por ALGORITMO
   */
  public Map<String, Integer> getExecutionsByAlgorithm(
    List<String> filterAlgorithms);

  /**
   * Consulta um mapa com o nmero total de execues por usurio (chave).
   * 
   * @return mapa com nmero de logins por USURIO
   */
  public Map<String, Integer> getLoginsByUser();

}
