package csdk.v2.extras.context.rest;

import org.glassfish.jersey.server.ResourceConfig;

import csdk.v2.api.core.IContext;

/**
 * Contexto de registro de recursos REST  API do cliente CSBase, atravs do
 * framework Jersey. Este framework permite a definio de recursos REST via
 * anotaes ou progamaticamente.
 *
 * @author Tecgraf
 */
public interface IRestContext extends IContext {

  /**
   * Registra os recursos especificados como APIs REST do cliente. Os recursos
   * devem ser instncias cadastradas no {@link ResourceConfig}.
   *
   * [ATENO] A aplicao *no* deve cadastrar pacotes ou classes no
   * ResourceConfig, somente instncias de objetos. Por limitaes de
   * classloading, os recursos cadastrados precisam ser intanciados dentro da
   * prpria aplicao ou no sero encontrados.
   *
   * Exemplo:
   *
   * {@code
   * ResourceConfig config = new ResourceConfig();
   * config.register(new MyRESTObject());
   * }
   *
   * NUNCA usar:
   * {@code
   * ResourceConfig config = new ResourceConfig();
   * config.register(MyRESTObject.class);
   * config.register("my.rest.package");
   * }
   *
   * @param resourceConfig a descrio dos recursos.
   * @throws RestException em caso de erro ao registrar os recursos REST.
   */
  public void registerResources(
    ResourceConfig resourceConfig) throws RestException;

  /**
   * Desregistra todos os recursos especificados.
   */
  public void unregisterResources();

}
