package csdk.v1_0.api.user;

import java.awt.Window;

import csdk.v1_0.api.core.IContext;

/**
 * Define os mtodos disponveis para consulta de usurios do sistema.
 */
public interface IUserContext extends IContext {

  /**
   * Obtm o usurio logado no sistema.
   * 
   * @return o usurio.
   * 
   * @throws UserException em caso de erro na consulta ao usurio.
   */
  public IUser getCurrentUser() throws UserException;

  /**
   * Solicita a lista de todos os usurios do sistema.
   * 
   * @param window a janela me da requisio.
   * 
   * @return a lista de todos os usurios
   * @throws UserException em caso de erro na consulta ao usurio.
   */
  public IUser[] getAllUsers(Window window) throws UserException;

  /**
   * Solicita o usurio que possui um determinado login.
   * 
   * @param login o login do usurio procurado
   * @param window a janela me da requisio.
   * 
   * @return o usurio que possui o login procurado ou null caso esse usurio
   *         no exista.
   * @throws UserException em caso de erro na consulta ao usurio.
   */
  public IUser getUserByLogin(String login, Window window) throws UserException;

}
