/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.common.logic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.Operation;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.ftc.utils.ByteBufferUtils;

public final class RemoteFileChannelImpl
implements RemoteFileChannel {
    private String host;
    private int port;
    private byte[] key;
    private byte[] identifier;
    private boolean writable;
    private boolean readOnly;
    private SocketChannel channel;
    private ByteBuffer operationBuffer;
    private ByteBuffer dataBuffer;
    private int bufferSize = 0x100000;
    private static int MAX_OP_SIZE = 256;

    public RemoteFileChannelImpl(byte[] identifier, boolean writable, String host, int port, byte[] key) {
        if (identifier == null || identifier.length > 255) {
            throw new InvalidParameterException("Parametro identifier invalido!");
        }
        if (host == null || host.isEmpty()) {
            throw new InvalidParameterException("Parametro host invalido!");
        }
        if (port < 0 || port > 65535) {
            throw new InvalidParameterException("Parametro port invalido!");
        }
        if (key == null || key.length > 255) {
            throw new InvalidParameterException("Parametro key invalido!");
        }
        this.host = host;
        this.port = port;
        this.key = key;
        this.operationBuffer = ByteBuffer.allocate(MAX_OP_SIZE);
        this.dataBuffer = ByteBuffer.allocate(this.bufferSize);
        this.identifier = identifier;
        this.writable = writable;
    }

    public RemoteFileChannelImpl(RemoteFileChannelInfo info) {
        this(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
    }

    @Override
    public boolean open(boolean readOnly) throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException {
        if (this.isOpen()) {
            throw new FailureException("O canal j\u00e1 est\u00e1 aberto!");
        }
        if (!readOnly && !this.writable) {
            throw new PermissionException("O arquivo n\u00e3o pode ser aberto para escrita.");
        }
        try {
            this.channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        Operation operation = readOnly ? Operation.OPEN_READ_ONLY : Operation.OPEN_READ_WRITE;
        ErrorCode errorCode = null;
        try {
            ByteBufferUtils.writeBytes(this.operationBuffer, this.channel, this.key);
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.INVALID_KEY)) {
                throw new PermissionException("Chave de acesso inv\u00e1lida.");
            }
            if (errorCode.equals((Object)ErrorCode.MAX_CLIENTS_REACHED)) {
                throw new MaxClientsReachedException("N\u00famero m\u00e1ximo de clientes no servidor atingido.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar se autenticar com a chave fornecida.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
        try {
            this.operationBuffer.put(operation.getCode());
            ByteBufferUtils.writeBytes(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), this.identifier);
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        if (!ErrorCode.OK.equals((Object)errorCode)) {
            this.release();
            if (errorCode.equals((Object)ErrorCode.FILE_NOT_FOUND)) {
                throw new FileNotFoundException("O arquivo n\u00e3o existe.");
            }
            if (errorCode.equals((Object)ErrorCode.NO_PERMISSION)) {
                throw new PermissionException("Sem permiss\u00e3o para abrir o arquivo.");
            }
            if (errorCode.equals((Object)ErrorCode.FAILURE)) {
                throw new FailureException("Falha no servidor ao tentar abrir o arquivo.");
            }
            throw new IllegalStateException("C\u00f3digo de erro inv\u00e1lido " + (Object)((Object)errorCode));
        }
        this.readOnly = readOnly;
        return true;
    }

    @Override
    public boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    @Override
    public void close() throws FailureException {
        this.openChannelCheck();
        ErrorCode errorCode = ErrorCode.FAILURE;
        try {
            ByteBufferUtils.writeByte(this.operationBuffer, this.channel, Operation.CLOSE.getCode());
            errorCode = this.checkReturnCode();
        }
        catch (IOException e) {
            throw new FailureException(e);
        }
        finally {
            this.release();
        }
        if (ErrorCode.FAILURE.equals((Object)errorCode)) {
            throw new FailureException("Falha no fechamento do canal do arquivo.");
        }
    }

    private ErrorCode checkReturnCode() throws IOException {
        byte code = ByteBufferUtils.readByte(this.operationBuffer, this.channel);
        ErrorCode errorCode = ErrorCode.valueOf(code);
        this.operationBuffer.clear();
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.operationBuffer = null;
            this.channel = null;
        }
    }

    private void openChannelCheck() {
        if (!this.isOpen()) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel executar a opera\u00e7\u00e3o, pois o canal n\u00e3o est\u00e1 aberto.");
        }
    }

    @Override
    public void setSize(long size) throws PermissionException, FailureException {
        this.openChannelCheck();
        if (size < 0L) {
            throw new InvalidParameterException("Parametro size invalido!");
        }
        if (!this.writable || this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        this.operationBuffer.put(Operation.SET_SIZE.getCode());
        try {
            ByteBufferUtils.writeLong(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), size);
            ErrorCode errorCode = this.checkReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getPosition() {
        this.openChannelCheck();
        try {
            ByteBufferUtils.writeByte(this.operationBuffer, this.channel, Operation.GET_POSITION.getCode());
            return ByteBufferUtils.readLong(this.operationBuffer, this.channel);
        }
        catch (IOException e) {
            this.release();
            return -1L;
        }
    }

    @Override
    public void setPosition(long position) throws FailureException {
        this.openChannelCheck();
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        try {
            this.operationBuffer.put(Operation.SET_POSITION.getCode());
            ByteBufferUtils.writeLong(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize(), position);
            ErrorCode errorCode = this.checkReturnCode();
            if (!errorCode.equals((Object)ErrorCode.OK)) {
                throw new FailureException("Falha ao alterar o tamanho do arquivo.");
            }
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
    }

    @Override
    public long getSize() {
        this.openChannelCheck();
        try {
            ByteBufferUtils.writeByte(this.operationBuffer, this.channel, Operation.GET_SIZE.getCode());
            long size = ByteBufferUtils.readLong(this.operationBuffer, this.channel);
            this.operationBuffer.clear();
            return size;
        }
        catch (IOException e) {
            this.release();
            return -1L;
        }
    }

    @Override
    public int read(byte[] target) throws FailureException {
        if (target == null) {
            throw new InvalidParameterException("Parametro target invalido!");
        }
        long position = this.getPosition();
        if (position < 0L) {
            throw new FailureException("Erro ao obter posicao atual do arquivo");
        }
        return this.read(target, 0, target.length, position);
    }

    @Override
    public int read(byte[] target, long position) throws FailureException {
        if (target == null) {
            throw new InvalidParameterException("Parametro target invalido!");
        }
        return this.read(target, 0, target.length, position);
    }

    @Override
    public int read(byte[] target, int offset, int length) throws FailureException {
        long position = this.getPosition();
        if (position < 0L) {
            throw new FailureException("Erro ao obter posicao atual do arquivo");
        }
        return this.read(target, offset, length, position);
    }

    @Override
    public int read(byte[] target, int offset, int length, long position) throws FailureException {
        this.openChannelCheck();
        if (target == null) {
            throw new InvalidParameterException("Parametro target invalido!");
        }
        if (offset < 0) {
            throw new InvalidParameterException("Parametro offset invalido!");
        }
        if (length < 0) {
            throw new InvalidParameterException("Parametro length invalido!");
        }
        if (target.length < offset + length) {
            throw new IndexOutOfBoundsException("Parametros offset + length \u00e9 maior que o array target!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        long size = this.getSize();
        if (position >= size) {
            return -1;
        }
        long bytesToRead = (long)length <= size - position ? (long)length : size - position;
        this.operationBuffer.put(Operation.READ.getCode());
        this.operationBuffer.putLong(position);
        this.operationBuffer.putLong(bytesToRead);
        this.operationBuffer.flip();
        try {
            this.channel.write(this.operationBuffer);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        finally {
            this.operationBuffer.clear();
        }
        int totalBytesRead = 0;
        ByteBuffer dstBuffer = ByteBuffer.wrap(target, offset, length);
        try {
            int bytesRead = 0;
            do {
                if ((bytesRead = this.channel.read(dstBuffer)) >= 0) continue;
                if (totalBytesRead == 0) {
                    this.release();
                    throw new FailureException("Falha ao ler dados do SocketChannel.");
                }
                break;
            } while ((long)(totalBytesRead += bytesRead) < bytesToRead);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        return totalBytesRead;
    }

    @Override
    public int write(byte[] source) throws PermissionException, FailureException, FileLockedException {
        if (source == null) {
            throw new InvalidParameterException("Parametro source invalido!");
        }
        long position = this.getPosition();
        if (position < 0L) {
            throw new FailureException("Erro ao obter posicao atual do arquivo");
        }
        return this.write(source, 0, source.length, position);
    }

    @Override
    public int write(byte[] source, long position) throws PermissionException, FailureException, FileLockedException {
        if (source == null) {
            throw new InvalidParameterException("Parametro source invalido!");
        }
        return this.write(source, 0, source.length, position);
    }

    @Override
    public int write(byte[] source, int offset, int length) throws PermissionException, FailureException, FileLockedException {
        long position = this.getPosition();
        if (position < 0L) {
            throw new FailureException("Erro ao obter posicao atual do arquivo");
        }
        return this.write(source, offset, length, position);
    }

    @Override
    public int write(byte[] source, int offset, int length, long position) throws PermissionException, FailureException, FileLockedException {
        byte code;
        this.openChannelCheck();
        if (!this.writable || this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        if (source == null) {
            throw new InvalidParameterException("Parametro source invalido!");
        }
        if (offset < 0) {
            throw new InvalidParameterException("Parametro offset invalido!");
        }
        if (length < 0) {
            throw new InvalidParameterException("Parametro length invalido!");
        }
        if (source.length < offset + length) {
            throw new IndexOutOfBoundsException("Parametros offset + length \u00e9 maior que o array source!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        this.operationBuffer.put(Operation.WRITE.getCode());
        this.operationBuffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), length);
            code = ByteBufferUtils.readByte(this.operationBuffer, this.channel);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        ErrorCode errorCode = ErrorCode.valueOf(code);
        if (errorCode.equals((Object)ErrorCode.FILE_LOCKED)) {
            throw new FileLockedException("Arquivo reservado para outro usu\u00e1rio.");
        }
        int totalBytesWritten = 0;
        ByteBuffer dstBuffer = ByteBuffer.wrap(source, offset, length);
        try {
            int bytesWritten;
            do {
                if ((bytesWritten = this.channel.write(dstBuffer)) >= 0) continue;
                if (totalBytesWritten == 0) {
                    this.release();
                    throw new FailureException("Falha ao ler dados do SocketChannel.");
                }
                break;
            } while ((totalBytesWritten += bytesWritten) < length);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        return totalBytesWritten;
    }

    @Override
    public long transferTo(long position, long count, OutputStream outputStream) throws FailureException {
        long bytesWrittenTotal;
        int bytesRead;
        this.openChannelCheck();
        if (outputStream == null) {
            throw new InvalidParameterException("Parametro outputStream invalido!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        if (count < 0L) {
            throw new InvalidParameterException("Parametro count invalido!");
        }
        this.operationBuffer.put(Operation.READ.getCode());
        this.operationBuffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        finally {
            this.operationBuffer.clear();
        }
        for (bytesWrittenTotal = 0L; bytesWrittenTotal < count; bytesWrittenTotal += (long)bytesRead) {
            this.dataBuffer.clear();
            if ((long)this.dataBuffer.capacity() > count - bytesWrittenTotal) {
                this.dataBuffer.limit((int)(count - bytesWrittenTotal));
            }
            try {
                bytesRead = this.channel.read(this.dataBuffer);
            }
            catch (IOException e) {
                this.release();
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            try {
                outputStream.write(this.dataBuffer.array(), 0, bytesRead);
                continue;
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
        }
        this.dataBuffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferTo(long position, long count, RemoteFileChannel target) throws FailureException, PermissionException, FileLockedException {
        long bytesWrittenTotal;
        int bytesRead;
        this.openChannelCheck();
        if (target == null) {
            throw new InvalidParameterException("Parametro target invalido!");
        }
        if (!target.isOpen()) {
            throw new InvalidParameterException("O canal provido no parametro target n\u00e3o esta aberto!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        if (count < 0L) {
            throw new InvalidParameterException("Parametro count invalido!");
        }
        this.operationBuffer.put(Operation.READ.getCode());
        this.operationBuffer.putLong(position);
        try {
            ByteBufferUtils.writeLong(this.operationBuffer, this.channel, PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize(), count);
        }
        catch (IOException e) {
            this.release();
            throw new FailureException(e);
        }
        finally {
            this.operationBuffer.clear();
        }
        for (bytesWrittenTotal = 0L; bytesWrittenTotal < count; bytesWrittenTotal += (long)bytesRead) {
            this.dataBuffer.clear();
            if ((long)this.dataBuffer.capacity() > count - bytesWrittenTotal) {
                this.dataBuffer.limit((int)(count - bytesWrittenTotal));
            }
            try {
                bytesRead = this.channel.read(this.dataBuffer);
            }
            catch (IOException e) {
                this.dataBuffer.clear();
                this.release();
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            target.write(this.dataBuffer.array(), 0, bytesRead, position + bytesWrittenTotal);
        }
        this.dataBuffer.clear();
        return bytesWrittenTotal;
    }

    @Override
    public long transferFrom(InputStream source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        long bytesReadTotal;
        int bytesRead;
        this.openChannelCheck();
        if (!this.writable || this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        if (source == null) {
            throw new InvalidParameterException("Parametro source invalido!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        if (count < 0L) {
            throw new InvalidParameterException("Parametro count invalido!");
        }
        byte[] bufferArray = this.dataBuffer.array();
        for (bytesReadTotal = 0L; bytesReadTotal < count; bytesReadTotal += (long)bytesRead) {
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            try {
                bytesRead = source.read(bufferArray, 0, len);
            }
            catch (IOException e) {
                throw new FailureException(e);
            }
            if (bytesRead == -1) break;
            this.write(bufferArray, 0, bytesRead, position + bytesReadTotal);
        }
        return bytesReadTotal;
    }

    @Override
    public long transferFrom(RemoteFileChannel source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        long bytesReadTotal;
        int bytesWrote;
        this.openChannelCheck();
        if (!this.writable || this.readOnly) {
            throw new PermissionException("Arquivo foi aberto somente para a leitura.");
        }
        if (source == null) {
            throw new InvalidParameterException("Parametro source invalido!");
        }
        if (!source.isOpen()) {
            throw new InvalidParameterException("O canal provido no parametro source n\u00e3o esta aberto!");
        }
        if (position < 0L) {
            throw new InvalidParameterException("Parametro position invalido!");
        }
        if (count < 0L) {
            throw new InvalidParameterException("Parametro count invalido!");
        }
        byte[] bufferArray = this.dataBuffer.array();
        for (bytesReadTotal = 0L; bytesReadTotal < count; bytesReadTotal += (long)bytesWrote) {
            int bytesRead;
            int len = bufferArray.length;
            if ((long)bufferArray.length > count - bytesReadTotal) {
                len = (int)(count - bytesReadTotal);
            }
            if ((bytesRead = source.read(bufferArray, 0, len)) < 0) {
                if (bytesReadTotal != 0L) break;
                return -1L;
            }
            bytesWrote = this.write(bufferArray, 0, bytesRead, position + bytesReadTotal);
            if (bytesWrote >= 0) continue;
            if (bytesReadTotal != 0L) break;
            return -1L;
        }
        return bytesReadTotal;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new InvalidParameterException("Parametro bufferSize invalido!");
        }
        this.bufferSize = bufferSize;
        this.dataBuffer = ByteBuffer.allocate(this.bufferSize);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

