/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.State;

public final class CloseState
implements State {
    private InternalState currentState;
    private ErrorCode errorCode = ErrorCode.FAILURE;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public CloseState() {
        this(ErrorCode.FAILURE);
    }

    public CloseState(ErrorCode error) {
        this.currentState = InternalState.INITIAL;
        this.errorCode = error;
        this.writing = true;
        logger.finer("Estado de fechamento.");
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                if (session.closeFileChannel()) {
                    this.errorCode = ErrorCode.OK;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.currentState = InternalState.CHANNEL_CLOSED;
            }
            case CHANNEL_CLOSED: {
                int bytesWritten = channel.write(buffer);
                if (bytesWritten < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                this.writing = false;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
        }
        session.setCurrentState(null);
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        CHANNEL_CLOSED;

    }
}

