/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.Operation;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.CloseState;
import tecgraf.ftc.server.states.GetPositionState;
import tecgraf.ftc.server.states.GetSizeState;
import tecgraf.ftc.server.states.OpenReadOnlyState;
import tecgraf.ftc.server.states.OpenReadWriteState;
import tecgraf.ftc.server.states.ReadState;
import tecgraf.ftc.server.states.SetPositionState;
import tecgraf.ftc.server.states.SetSizeState;
import tecgraf.ftc.server.states.State;
import tecgraf.ftc.server.states.WriteState;

public final class GetOperationState
implements State {
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public GetOperationState() {
        logger.finer("Estado de ler opera\u00e7\u00f5es.");
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        int bytesRead = channel.read(buffer);
        if (bytesRead < 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
            }
            return false;
        }
        if (bytesRead > 0) {
            session.markLastActivity();
        }
        if (buffer.hasRemaining()) {
            return true;
        }
        buffer.flip();
        byte operationCode = buffer.get();
        buffer.clear();
        Operation operation = Operation.valueOf(operationCode);
        if (operation == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Opera\u00e7\u00e3o desconhecida " + operationCode);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opera\u00e7\u00e3o obtida " + (Object)((Object)operation));
        }
        session.setCurrentState(this.getState(operation));
        return true;
    }

    private State getState(Operation operation) {
        switch (operation) {
            case OPEN_READ_ONLY: {
                return new OpenReadOnlyState();
            }
            case OPEN_READ_WRITE: {
                return new OpenReadWriteState();
            }
            case CLOSE: {
                return new CloseState();
            }
            case SET_SIZE: {
                return new SetSizeState();
            }
            case GET_POSITION: {
                return new GetPositionState();
            }
            case SET_POSITION: {
                return new SetPositionState();
            }
            case GET_SIZE: {
                return new GetSizeState();
            }
            case READ: {
                return new ReadState();
            }
            case WRITE: {
                return new WriteState();
            }
        }
        return null;
    }

    @Override
    public boolean write(Session session) {
        return true;
    }

    @Override
    public boolean isWriting() {
        return false;
    }
}

