/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public final class SetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private ErrorCode errorCode;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public SetPositionState() {
        logger.finer("Estado para definir a posi\u00e7\u00e3o de um arquivo.");
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                int bytesRead = channel.read(buffer);
                if (bytesRead < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Posi\u00e7\u00e3o recebida: " + this.position);
                }
                this.writing = true;
                FileChannel fileChannel = session.getFileChannel();
                try {
                    fileChannel.position(this.position);
                    this.errorCode = ErrorCode.OK;
                }
                catch (IOException e) {
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    this.errorCode = ErrorCode.FAILURE;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.currentState = InternalState.POSITION_READ;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case POSITION_READ: {
                int bytesWritten = channel.write(buffer);
                if (bytesWritten < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                break;
            }
            default: {
                return false;
            }
        }
        session.setCurrentState(new GetOperationState());
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ;

    }
}

