/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.ErrorCode;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;
import tecgraf.ftc.utils.IOUtils;

public final class WriteState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode;
    private long position;
    private long count;
    private long bytesReceived;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    public WriteState() {
        logger.finer("Estado de escrita.");
    }

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        FileChannel fileChannel = session.getFileChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                long bytesRead = channel.read(buffer);
                if (bytesRead < 0L) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0L) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                if (this.position < 0L) {
                    try {
                        this.position = fileChannel.position();
                    }
                    catch (IOException e) {
                        logger.finer("Erro ao ler posi\u00e7\u00e3o do arquivo.");
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        return false;
                    }
                }
                this.currentState = InternalState.POSITION_READ;
                return true;
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                long bytesRead = channel.read(buffer);
                if (bytesRead < 0L) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0L) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.BYTE_COUNT_READ;
                this.writing = true;
                return true;
            }
            case CHECKED: {
                long bytesRead;
                FileChannelRequestInfo fileInfo = session.getFileChannelInfo();
                if (fileInfo.useTransferTo()) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Using TransferFrom");
                        logger.finest("position=" + this.position);
                        logger.finest("count=" + this.count);
                        logger.finest("bytesReceived=" + this.bytesReceived);
                    }
                    bytesRead = fileChannel.transferFrom(channel, this.position + this.bytesReceived, this.count - this.bytesReceived);
                } else {
                    bytesRead = IOUtils.transferFromNonBlock(fileChannel, this.position + this.bytesReceived, this.count - this.bytesReceived, channel, buffer);
                }
                if (bytesRead < 0L) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesRead > 0L) {
                    session.markLastActivity();
                    this.bytesReceived += bytesRead;
                    fileChannel.position(this.position + this.bytesReceived);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Recebidos " + bytesRead);
                }
                if (this.bytesReceived != this.count) break;
                buffer.clear();
                this.currentState = InternalState.BYTES_RECEIVED;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                this.errorCode = session.getFileServer().isLocked(fileChannelInfo.getRequester(), fileChannelInfo.getFileId()) ? ErrorCode.FILE_LOCKED : ErrorCode.OK;
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                this.currentState = InternalState.RETURN_MSG_COMPOSED;
            }
            case RETURN_MSG_COMPOSED: {
                int bytesWritten = channel.write(buffer);
                if (bytesWritten < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("C\u00f3digo " + (Object)((Object)this.errorCode) + " enviado.");
                }
                if (this.errorCode.equals((Object)ErrorCode.OK)) {
                    this.currentState = InternalState.CHECKED;
                    this.writing = false;
                    if (!fileChannelInfo.useTransferTo()) break;
                    try {
                        FileChannel fileChannel = session.getFileChannel();
                        if (this.position <= fileChannel.size()) break;
                        ByteBuffer src = ByteBuffer.wrap(new byte[]{0});
                        long currentPosition = fileChannel.position();
                        fileChannel.position(this.position);
                        fileChannel.write(src);
                        fileChannel.position(currentPosition);
                        break;
                    }
                    catch (IOException e) {
                        session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                        return false;
                    }
                }
                session.setCurrentState(new GetOperationState());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        CHECKED,
        POSITION_READ,
        BYTE_COUNT_READ,
        RETURN_MSG_COMPOSED,
        BYTES_RECEIVED;

    }
}

