/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.server.FileChannelRequestInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.states.State;
import tecgraf.ftc.server.states.ValidateKeyState;

public final class Session {
    private SocketChannel channel;
    private ByteBuffer buffer;
    private FileServer fileServer;
    private State currentState;
    private FileChannelRequestInfo fileChannelInfo;
    private FileChannel fileChannel;
    private boolean readOnly;
    private long lastActivity = 0L;
    private boolean valid = true;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    Session(SocketChannel channel, FileServer fileServer) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(fileServer.getConfig().getClientBufferSize());
        this.fileServer = fileServer;
        this.currentState = new ValidateKeyState();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public FileServer getFileServer() {
        return this.fileServer;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(State state) {
        this.currentState = state;
    }

    public FileChannelRequestInfo getFileChannelInfo() {
        return this.fileChannelInfo;
    }

    public void setFileChannelInfo(FileChannelRequestInfo fileChannelInfo) {
        this.fileChannelInfo = fileChannelInfo;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void close() {
        this.closeFileChannel();
        try {
            this.channel.close();
            logger.info("SocketChannel closed");
        }
        catch (IOException e) {
            if (this.fileChannelInfo != null) {
                this.fileServer.exceptionRaised(e, this.fileChannelInfo.getFileId());
            }
            this.fileServer.exceptionRaised(e);
        }
        this.valid = false;
        this.currentState = null;
    }

    public boolean closeFileChannel() {
        if (this.fileChannel == null) {
            return false;
        }
        try {
            this.fileChannel.close();
            logger.info("FileChannel closed");
        }
        catch (IOException e) {
            if (this.fileChannelInfo != null) {
                this.fileServer.exceptionRaised(e, this.fileChannelInfo.getFileId());
            } else {
                this.fileServer.exceptionRaised(e);
            }
        }
        finally {
            this.fileChannel = null;
            this.fileServer.fileChannelClosed(this.fileChannelInfo.getRequester(), this.fileChannelInfo.getFileId());
        }
        return true;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void markLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public boolean isWriting() {
        if (this.currentState == null) {
            return false;
        }
        return this.currentState.isWriting();
    }

    public boolean isValid() {
        return this.valid;
    }

    public SocketAddress getClientAddress() {
        return this.getChannel().socket().getRemoteSocketAddress();
    }

    @Deprecated
    public boolean isLoggable(Level level) {
        return Logger.getLogger("tecgraf.ftc").isLoggable(level);
    }
}

