/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc.common.logic.PrimitiveTypeSize;
import tecgraf.ftc.server.Session;
import tecgraf.ftc.server.states.GetOperationState;
import tecgraf.ftc.server.states.State;

public final class GetSizeState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long size;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    public GetSizeState() {
        logger.finer("Estado de obten\u00e7\u00e3o do tamanho do arquivo.");
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                FileChannel fileChannel = session.getFileChannel();
                try {
                    this.size = fileChannel.size();
                }
                catch (IOException e) {
                    this.size = -1L;
                    logger.severe("Falha ao ler tamanho do arquivo!");
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                }
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                buffer.putLong(this.size);
                buffer.flip();
                this.currentState = InternalState.SIZE_READ;
            }
            case SIZE_READ: {
                int bytesWritten;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Enviando o tamanho do arquivo " + this.size);
                }
                if ((bytesWritten = channel.write(buffer)) < 0) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(String.format("A conex\u00e3o com o cliente %s foi interrompida.", session.getClientAddress().toString()));
                    }
                    return false;
                }
                if (bytesWritten > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                break;
            }
            default: {
                return false;
            }
        }
        session.setCurrentState(new GetOperationState());
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        SIZE_READ;

    }
}

