/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.algorithm.v1.impl;

import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.algorithm.v1.AlgorithmsApiService;
import ibase.rest.api.algorithm.v1.NotFoundException;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmNotFoundException;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmServiceAdapter;
import ibase.rest.api.algorithm.v1.adapter.VersionNotFoundException;
import ibase.rest.model.algorithm.v1.Algorithm;
import ibase.rest.model.algorithm.v1.AlgorithmConfiguration;
import ibase.rest.model.algorithm.v1.AlgorithmVersion;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class AlgorithmsApiServiceImpl
extends AlgorithmsApiService {
    public static final String RESOURCE_BUNDLE = "language.AlgorithmsApi";
    private static final Logger logger = Logger.getLogger("AlgorithmsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response algorithmsAlgorithmIdGet(String algorithmId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        Optional<Algorithm> algorithm = service.getAlgorithm(algorithmId);
        if (algorithm.isPresent()) {
            return Response.ok().entity((Object)algorithm.get()).build();
        }
        return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsGet(String algorithmId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.versions.get.info", new String[0]));
        if (algorithmId == null || algorithmId.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.empty", new String[]{algorithmId}));
        }
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            List<AlgorithmVersion> versions = service.getAlgorithmVersions(algorithmId);
            return Response.ok().entity(versions).build();
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdGet(String algorithmId, String versionId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.version.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            Optional<AlgorithmVersion> version = service.getAlgorithmVersion(algorithmId, versionId);
            if (version.isPresent()) {
                return Response.ok().entity((Object)version.get()).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.version.id.not.found", new String[]{versionId, algorithmId}));
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdConfigurationGet(String algorithmId, String versionId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.version.configuration.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            AlgorithmConfiguration config = service.getAlgorithmConfiguration(algorithmId, versionId);
            return Response.ok().entity((Object)config).build();
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
        catch (VersionNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.version.id.not.found", new String[]{versionId, algorithmId}));
        }
    }

    @Override
    public Response algorithmsGet(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        List<Algorithm> algorithms = name != null ? service.getAlgorithms(a -> a.getName().toUpperCase().startsWith(name.toUpperCase())) : service.getAlgorithms(null);
        return Response.ok().entity(algorithms).build();
    }
}

