/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.algorithm.v1;

import ibase.rest.api.algorithm.v1.AlgorithmsApiService;
import ibase.rest.api.algorithm.v1.NotFoundException;
import ibase.rest.api.algorithm.v1.factories.AlgorithmsApiServiceFactory;
import ibase.rest.model.algorithm.v1.Algorithm;
import ibase.rest.model.algorithm.v1.AlgorithmConfiguration;
import ibase.rest.model.algorithm.v1.AlgorithmVersion;
import ibase.rest.model.algorithm.v1.InlineResponse200;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/algorithms")
@Produces(value={"application/json"})
@Api(description="the algorithms API")
public class AlgorithmsApi {
    private final AlgorithmsApiService delegate = AlgorithmsApiServiceFactory.getAlgorithmsApi();

    @GET
    @Path(value="/{algorithmId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find an algorithm by its ID", notes="This endpoint returns an algorithm by its ID. The ID is encoded in Base64.", response=Algorithm.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Algorithm.class), @ApiResponse(code=404, message="Algorithm not found.", response=Algorithm.class)})
    public Response algorithmsAlgorithmIdGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdGet(algorithmId, locale, securityContext);
    }

    @GET
    @Path(value="/{algorithmId}/versions")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the versions of an algorithm.", notes="This endpoint returns the list of the versions available for a specific algorithm.", response=AlgorithmVersion.class, responseContainer="List", tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=AlgorithmVersion.class, responseContainer="List"), @ApiResponse(code=403, message="if the user is not allowed to access this algorithm", response=AlgorithmVersion.class, responseContainer="List")})
    public Response algorithmsAlgorithmIdVersionsGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdVersionsGet(algorithmId, locale, securityContext);
    }

    @GET
    @Path(value="/{algorithmId}/versions/{versionId}/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the information about the parameter configuration of an algorithm version.", notes="This endpoint returns the detail information about an algorithm version parameter configuration. The parameter configuration is the set of groups with input and output parameters required for the algorithm execution.", response=AlgorithmConfiguration.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=AlgorithmConfiguration.class), @ApiResponse(code=400, message="If the version identification provided in the versionId parameter does not exist or if the algorithm identification provided in algorithmId does not exist.", response=AlgorithmConfiguration.class), @ApiResponse(code=403, message="If the authenticated user is not authorized to do this operation", response=AlgorithmConfiguration.class)})
    public Response algorithmsAlgorithmIdVersionsVersionIdConfigurationGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The ID of an algorithm version.", required=true) @PathParam(value="versionId") String versionId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdVersionsVersionIdConfigurationGet(algorithmId, versionId, locale, securityContext);
    }

    @GET
    @Path(value="/{algorithmId}/versions/{versionId}/documentation/download/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download a algorithm version documentation file", notes="This endpoint returns the documentation file of a algorithm version.", response=void.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified algorithms's binary", response=void.class), @ApiResponse(code=400, message="invalid version format", response=void.class), @ApiResponse(code=404, message="if not found the specified combination of algorithmId, versionId and platformId", response=void.class)})
    public Response algorithmsAlgorithmIdVersionsVersionIdDocumentationDownloadGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The ID of an algorithm version.", required=true) @PathParam(value="versionId") String versionId, @ApiParam(value="The name of the file to be downloaded from the algorithm version documentation.", required=true) @QueryParam(value="fileName") String fileName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdVersionsVersionIdDocumentationDownloadGet(algorithmId, versionId, fileName, locale, securityContext);
    }

    @GET
    @Path(value="/{algorithmId}/versions/{versionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the information about a member of a project team.", notes="This endpoint returns the detail information about an algorithm version.", response=AlgorithmVersion.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=AlgorithmVersion.class), @ApiResponse(code=400, message="If the version identification provided in the versionId parameter does not exist or if the algorithm identification provided in algorithmId does not exist.", response=AlgorithmVersion.class), @ApiResponse(code=403, message="If the authenticated user is not authorized to do this operation", response=AlgorithmVersion.class)})
    public Response algorithmsAlgorithmIdVersionsVersionIdGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The ID of an algorithm version.", required=true) @PathParam(value="versionId") String versionId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdVersionsVersionIdGet(algorithmId, versionId, locale, securityContext);
    }

    @GET
    @Path(value="/{algorithmId}/versions/{versionId}/platform/{platformId}/download")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download a algorithms's binary", notes="", response=void.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified algorithms's binary", response=void.class), @ApiResponse(code=400, message="invalid version format", response=void.class), @ApiResponse(code=404, message="if not found the specified combination of algorithmId, versionId and platformId", response=void.class)})
    public Response algorithmsAlgorithmIdVersionsVersionIdPlatformPlatformIdDownloadGet(@ApiParam(value="The ID of an algorithm.", required=true) @PathParam(value="algorithmId") String algorithmId, @ApiParam(value="The ID of an algorithm version.", required=true) @PathParam(value="versionId") String versionId, @ApiParam(value="The platform of algorithm.", required=true) @PathParam(value="platformId") String platformId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsAlgorithmIdVersionsVersionIdPlatformPlatformIdDownloadGet(algorithmId, versionId, platformId, locale, securityContext);
    }

    @GET
    @Path(value="/documentation/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download all algorithm documentation files", notes="This endpoint returns the documentation of all algorithms as a json file.", response=InlineResponse200.class, responseContainer="List", tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="The documentation of all algorithms", response=InlineResponse200.class, responseContainer="List"), @ApiResponse(code=400, message="invalid version format", response=InlineResponse200.class, responseContainer="List"), @ApiResponse(code=404, message="if not found the specified combination of algorithmId, versionId and platformId", response=InlineResponse200.class, responseContainer="List")})
    public Response algorithmsDocumentationGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsDocumentationGet(locale, securityContext);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List the available algorithms.", notes="This endpoint returns information about the algorithms available for submission on execution environments. The response includes the algoritm name and other details about each algoritm. ", response=Algorithm.class, responseContainer="List", tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of algorithms", response=Algorithm.class, responseContainer="List"), @ApiResponse(code=200, message="Unexpected error", response=Algorithm.class, responseContainer="List")})
    public Response algorithmsGet(@ApiParam(value="Filter the algorithms by the begining of the name provided. Only the algorithms which name begins with the filter name will be returned. This filter is not case sensitive. If this filter is not provided, the response list all the algorithms available.") @QueryParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsGet(name, locale, securityContext);
    }

    @GET
    @Path(value="/tools")
    @Produces(value={"application/json"})
    @ApiOperation(value="Download a algorithms's tools", notes="", response=void.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified tools's contents", response=void.class), @ApiResponse(code=400, message="if was invalid path", response=void.class)})
    public Response algorithmsToolsGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @ApiParam(value="relative path to download de tools.") @QueryParam(value="path") String path, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.algorithmsToolsGet(locale, path, securityContext);
    }
}

