/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import ibase.rest.model.algorithm.v1.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class InputFileParameter
extends Parameter {
    private Boolean multipleSelection = false;
    private Boolean sort = true;
    private Boolean allowsPipe = true;
    private Boolean useFilter = false;
    private CategoryEnum category = null;
    private Boolean useToLoadParam = false;

    public InputFileParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public InputFileParameter sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="If the input files must be sorted. This option is used only if multipe_selection is true.")
    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public InputFileParameter allowsPipe(Boolean allowsPipe) {
        this.allowsPipe = allowsPipe;
        return this;
    }

    @ApiModelProperty(value="If the input file parameter can be used as pipe by the algorithm.")
    public Boolean getAllowsPipe() {
        return this.allowsPipe;
    }

    public void setAllowsPipe(Boolean allowsPipe) {
        this.allowsPipe = allowsPipe;
    }

    public InputFileParameter useFilter(Boolean useFilter) {
        this.useFilter = useFilter;
        return this;
    }

    @ApiModelProperty(value="If a filter must be provided in the user interface.")
    public Boolean getUseFilter() {
        return this.useFilter;
    }

    public void setUseFilter(Boolean useFilter) {
        this.useFilter = useFilter;
    }

    public InputFileParameter category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="If the parameter accepts a folder, a regular file or both.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public InputFileParameter useToLoadParam(Boolean useToLoadParam) {
        this.useToLoadParam = useToLoadParam;
        return this;
    }

    @ApiModelProperty(value="If the parameter is used to load others parameters values.")
    public Boolean getUseToLoadParam() {
        return this.useToLoadParam;
    }

    public void setUseToLoadParam(Boolean useToLoadParam) {
        this.useToLoadParam = useToLoadParam;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputFileParameter inputFileParameter = (InputFileParameter)o;
        return Objects.equals(this.multipleSelection, inputFileParameter.multipleSelection) && Objects.equals(this.sort, inputFileParameter.sort) && Objects.equals(this.allowsPipe, inputFileParameter.allowsPipe) && Objects.equals(this.useFilter, inputFileParameter.useFilter) && Objects.equals((Object)this.category, (Object)inputFileParameter.category) && Objects.equals(this.useToLoadParam, inputFileParameter.useToLoadParam) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.multipleSelection, this.sort, this.allowsPipe, this.useFilter, this.category, this.useToLoadParam, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputFileParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    allowsPipe: ").append(this.toIndentedString(this.allowsPipe)).append("\n");
        sb.append("    useFilter: ").append(this.toIndentedString(this.useFilter)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    useToLoadParam: ").append(this.toIndentedString(this.useToLoadParam)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        REGULAR("Regular"),
        FOLDER("Folder"),
        BOTH("Both");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

