/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import ibase.rest.model.algorithm.v1.Action;
import ibase.rest.model.algorithm.v1.ParameterGroup;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlgorithmConfiguration {
    private String command = null;
    private ExecutionTypeEnum executionType = null;
    private Boolean loadParameters = false;
    private List<ParameterGroup> groups = new ArrayList<ParameterGroup>();
    private List<Action> actions = new ArrayList<Action>();

    public AlgorithmConfiguration command(String command) {
        this.command = command;
        return this;
    }

    @ApiModelProperty(value="The execution command for submission. At the submission, this command will be followed by the list of parameters provided by the user.")
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public AlgorithmConfiguration executionType(ExecutionTypeEnum executionType) {
        this.executionType = executionType;
        return this;
    }

    @ApiModelProperty(value="")
    public ExecutionTypeEnum getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(ExecutionTypeEnum executionType) {
        this.executionType = executionType;
    }

    public AlgorithmConfiguration loadParameters(Boolean loadParameters) {
        this.loadParameters = loadParameters;
        return this;
    }

    @ApiModelProperty(value="If the user can load and save the parameters values from/to a project file.")
    public Boolean getLoadParameters() {
        return this.loadParameters;
    }

    public void setLoadParameters(Boolean loadParameters) {
        this.loadParameters = loadParameters;
    }

    public AlgorithmConfiguration groups(List<ParameterGroup> groups) {
        this.groups = groups;
        return this;
    }

    public AlgorithmConfiguration addGroupsItem(ParameterGroup groupsItem) {
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="The group of parameters")
    public List<ParameterGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ParameterGroup> groups) {
        this.groups = groups;
    }

    public AlgorithmConfiguration actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public AlgorithmConfiguration addActionsItem(Action actionsItem) {
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="The actions that can be applied on parameters or groups")
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmConfiguration algorithmConfiguration = (AlgorithmConfiguration)o;
        return Objects.equals(this.command, algorithmConfiguration.command) && Objects.equals((Object)this.executionType, (Object)algorithmConfiguration.executionType) && Objects.equals(this.loadParameters, algorithmConfiguration.loadParameters) && Objects.equals(this.groups, algorithmConfiguration.groups) && Objects.equals(this.actions, algorithmConfiguration.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.command, this.executionType, this.loadParameters, this.groups, this.actions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmConfiguration {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    executionType: ").append(this.toIndentedString((Object)this.executionType)).append("\n");
        sb.append("    loadParameters: ").append(this.toIndentedString(this.loadParameters)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExecutionTypeEnum {
        SIMPLE("simple"),
        MULTIPLE("multiple");

        private String value;

        private ExecutionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

