/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import tecgraf.javautils.gui.table.AbstractColumn;
import tecgraf.javautils.gui.table.ColumnsObjectTableModel;

public class ColumnsObjectTableModelSample {
    public static void main(String[] args) {
        ArrayList<Person> phonebook = new ArrayList<Person>();
        phonebook.add(new Person("Pedro", 29));
        phonebook.add(new Person("Renata", 26));
        final ColumnsObjectTableModel model = new ColumnsObjectTableModel(phonebook, new NameColumn(), new AgeColumn());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add(new JScrollPane(new JTable(model)));
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    static class AgeColumn
    extends AbstractColumn<Person> {
        public AgeColumn() {
            super(Integer.class);
        }

        @Override
        public String getColumnName() {
            return "Age";
        }

        @Override
        public boolean isEditable(Person obj) {
            return true;
        }

        @Override
        public void setValue(Person obj, Object value) {
            obj.age = (Integer)value;
        }

        @Override
        public Object getValue(Person obj) {
            return obj.age;
        }
    }

    static class NameColumn
    extends AbstractColumn<Person> {
        public NameColumn() {
            super(String.class);
        }

        @Override
        public String getColumnName() {
            return "Name";
        }

        @Override
        public Object getValue(Person obj) {
            return obj.name;
        }
    }

    static class Person {
        private String name;
        private int age;

        Person(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }
}

