/*
 * $Id: ComboUtil.java 76914 2008-06-05 21:03:48Z clinio $
 */
package tecgraf.javautils.gui;

import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

/**
 * Classe com mtodos utilitrios para preenchimento de listboxes (tipo combo)
 * para compartilhamento de aplicaes (originrias do WebSintesi).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ComboUtil {

  /**
   * Atualizao de uma lista de seleo (combo box), com base em uma lista de
   * objetos.
   * 
   * @param <T> tipo de objetos da lista
   * @param combo lista de seleo a ser preenchida com os objetos
   * @param list conjunto de objetos da lista
   * @param tryIndex o ndice inicial para tentativa de seleo
   * 
   * @return retorna true, se a lista de seleo est ativa, caso contrrio,
   *         retorna false
   */
  static public <T> boolean updateFromList(final JComboBox combo, final List<T> list, final int tryIndex) {
    if ((list == null) || (list.size() <= 0)) {
      return ComboUtil.updateFromArray(combo, null, 0);
    }

    final Object[] array = list.toArray();
    return ComboUtil.updateFromArray(combo, array, tryIndex);
  }

  /**
   * Atualizao de uma lista de seleo (combo box), com base em um array de
   * objetos.
   * 
   * @param combo lista de seleo a ser preenchida com os objetos
   * @param array array contendo os objetos da lista
   * @param tryIndex o ndice inicial para tentativa de seleo
   * 
   * @return retorna true, se a lista de seleo est ativa, caso contrrio,
   *         retorna false
   */
  static public boolean updateFromArray(final JComboBox combo, final Object[] array, final int tryIndex) {
    if ((array == null) || (array.length <= 0)) {
      combo.setModel(new DefaultComboBoxModel());
      combo.setEnabled(false);
      return false;
    }

    combo.setModel(new DefaultComboBoxModel(array));
    combo.setEnabled(true);

    // modelo j seleciona primeiro ndice por default
    if (tryIndex > -1 && array.length > tryIndex) {
      combo.setSelectedIndex(tryIndex);
    }
    return true;
  }
}
