package tecgraf.javautils.gui;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

import tecgraf.javautils.gui.MenuButton.PopupPosition;

/**
 * Exemplo de uso da classe {@link MenuButton}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class MenuButtonSample {

  /**
   * Testa os mtodos desta classe.
   * 
   * @param args
   */
  public static void main(String[] args) {
    final JFrame frame = new JFrame("Teste para MenuButton");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    Container contentPane = frame.getContentPane();
    contentPane.setLayout(new GridBagLayout());
    /*
     * popup para baixo (texto)
     */
    MenuButton bottom1 = createTestButton("Bottom", PopupPosition.BOTTOM, true);
    contentPane.add(bottom1, new GBC(0, 0).northwest().pushxy());
    /*
     * popup para baixo (texto)
     */
    MenuButton bottom2 =
      createTestButton("Bottom", PopupPosition.BOTTOM, false);
    contentPane.add(bottom2, new GBC(1, 0).north().pushxy());
    /*
     * popup para a esquerda (imagem)
     */
    MenuButton left =
      createTestButton(GUIResources.BUTTON_CALENDAR_ICON, PopupPosition.LEFT,
        false);
    contentPane.add(left, new GBC(2, 0).northeast().pushxy());
    /*
     * popup para cima (imagem)
     */
    MenuButton up1 =
      createTestButton(GUIResources.BUTTON_CALENDAR_ICON, PopupPosition.TOP,
        false);
    contentPane.add(up1, new GBC(0, 1).southwest().pushxy());
    /*
     * popup para a direita (texto)
     */
    MenuButton right = createTestButton("Right", PopupPosition.RIGHT, false);
    contentPane.add(right, new GBC(1, 1).south().pushxy());
    /*
     * popup para cima (imagem)
     */
    MenuButton up2 =
      createTestButton(GUIResources.BUTTON_CALENDAR_ICON, PopupPosition.TOP,
        true);
    contentPane.add(up2, new GBC(2, 1).southeast().pushxy());

    frame.setSize(450, 150);
    frame.setVisible(true);
  }

  /**
   * Cria um boto sem label (apenas com cone) para os testes. Associa aes
   * dummy ao boto.
   * 
   * @param icon cone associado ao boto
   * @param pos posio do popup
   * @param alignRight <code>true</code> se o popup deve ser alinhado  direita
   *        com o boto
   * @return boto
   */
  private static MenuButton createTestButton(ImageIcon icon, PopupPosition pos,
    boolean alignRight) {
    return addTestActions(new MenuButton(icon, pos, alignRight));
  }

  /**
   * Mtodo para criao de um boto com label (sem cone) para os testes.
   * Associa aes dummy ao boto.
   * 
   * @param label texto do boto
   * @param pos posio do popup
   * @param alignRight <code>true</code> se o popup deve ser alinhado  direita
   *        com o boto
   * @return boto
   */
  private static MenuButton createTestButton(String label, PopupPosition pos,
    boolean alignRight) {
    return addTestActions(new MenuButton(label, pos, alignRight));
  }

  /**
   * Adiciona aes dummy a um boto. Usado para os testes.
   * 
   * @param menuButton boto
   * @return o prprio boto
   */
  private static MenuButton addTestActions(MenuButton menuButton) {
    menuButton.add(new JMenuItem(new AbstractAction("item 1") {
      @Override
      public void actionPerformed(ActionEvent e) {
        System.out.println("executando item 1...");
      }
    }));
    menuButton.add(new AbstractAction("item 2") {
      @Override
      public void actionPerformed(ActionEvent e) {
        System.out.println("executando item 2...");
      }
    });
    return menuButton;
  }
}
