package tecgraf.javautils.gui.crud;

import java.util.List;

import javax.swing.JLabel;

import tecgraf.javautils.gui.crud.gui.actions.RegistrationAction;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Interface de descrio de comportamento
 *
 * @author Tecgraf
 * @param <M> tipo do objeto do modelo.
 * @param <I> tipo do objeto da interface.
 */
public interface IRegistrationDescriptor<M, I> {

  /**
   * Retorna classe
   *
   * @return classe
   */
  public Class<?> getColumnClass();

  /**
   * Retorna largura desejvel da coluna
   *
   * @param i ndice
   * @return largura
   */
  public int getColumnWidth(int i);

  /**
   * Consulta o nmero de colunas para a tabela.
   *
   * @return nmero
   */
  public int getNumColumns();

  /**
   * Consulta o mmero de objetos gerenciados.
   *
   * @return nmero
   */
  public int getNumObjects();

  /**
   * Retorna objeto do modelo
   *
   * @param row linha
   * @return objeto
   */
  public M getObject(int row);

  /**
   * Retorna nome da coluna
   *
   * @param i ndice
   * @return nome
   */
  public String getColumnName(int i);

  /**
   * Faz renderizao deum coluna.
   *
   * @param label {@code JLabel} associado.
   * @param object objeto do modelo.
   * @param column ndice da coluna
   * @param isSelected indicativo de seleo.
   */
  public void renderColumn(JLabel label, M object, int column,
    boolean isSelected);

  /**
   * Callback de deleo de objeto do modelo.
   *
   * @param object objeto
   * @return se deleo pode ser feita.
   */
  public boolean delCallback(M object);

  /**
   * Callback de adio de objeto.
   *
   * @param object objeto
   * @return se adio pode ser feita.
   */
  public boolean addCallback(I object);

  /**
   * Callback de objeto editado.
   *
   * @param oldObject objeto do modelo editado
   * @param newObject novo objeto editado (de interface).
   * @return indicativo de operao possvel.
   */
  public boolean editCallback(M oldObject, I newObject);

  /**
   * Converte objeto do modelo em objeto de interface
   *
   * @param object objeto do modelo.
   * @return objeto de interface.
   */
  public I toIHCObject(M object);

  /**
   * Cria painel de edio.
   *
   * @param mainPanel painel principal
   * @return painel
   */
  public RegistrationEditionPanel<M, I> getRegistrationEditPanel(
    RegistrationMainPanel<M, I> mainPanel);

  /**
   * Monta lista de aes para o menu de popup.
   *
   * @param mainPanel painel principal
   * @return lista de aes
   */
  public List<RegistrationAction<M, I>> getPopupMenuActions(
    RegistrationMainPanel<M, I> mainPanel);

  /**
   * Monta lista de aes para o menu de outras aes.
   *
   * @param mainPanel painel principal
   * @return lista de aes
   */
  public List<RegistrationAction<M, I>> getOthersMenuActions(
    RegistrationMainPanel<M, I> mainPanel);

  /**
   * Monta lista de aes para a toolbar.
   *
   * @param mainPanel painel principal
   * @return lista de aes
   */
  public List<RegistrationAction<M, I>> getToolbarActions(
    RegistrationMainPanel<M, I> mainPanel);

}
