package tecgraf.javautils.gui.crud.utils;

import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Pacote utilitrio.
 * 
 * @author Tecgraf
 */
public class RegistrationUtils {

  /**
   * Utilitrio para busca de conformao de deleo.
   * 
   * @param mainPanel painel
   * @param object objeto.
   * @return indicativo
   */
  public static <M, I> boolean confirmDeletion(
    final RegistrationMainPanel<M, I> mainPanel, final M object) {
    final String no = mainPanel.getString("delete.no.option");
    final String yes = mainPanel.getString("delete.yes.option");
    final String message = mainPanel.getString("delete.confirm.message");
    final String title = "";
    final String[] options = new String[] { yes, no };
    final int option =
      StandardDialogs.showOptionDialog(mainPanel, title, message, options);
    return option == 0;
  }
}
