package tecgraf.javautils.gui.panel;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.panel.ExpandablePanel.Position;

/**
 * Exemplo com {@link ExpandablePanel} e {@link ExpandablePanelGroup}.
 * 
 * @author Tecgraf
 */
public class ExpandablePanelSample {

  /**
   * Posio default para o controle.
   */
  private static final Position POS = Position.CONTROL_LEFT;
  /**
   * Flag para exibio do separador.
   */
  private static final boolean SHOW_SEPARATOR = false;
  /**
   * Flag para identao do contedo.
   */
  private static final boolean IDENT_CONTENT = true;

  /**
   * Cria um painel expansvel com contedo fixo, para testes.
   * 
   * @param title ttulo do painel
   * 
   * @return painel expansvel
   */
  private static ExpandablePanel makeExpandablePanel(String title) {
    ExpandablePanel ep =
      new ExpandablePanel(title, POS, SHOW_SEPARATOR, IDENT_CONTENT);
    int y = 0;
    ep.add(new JLabel("blabla"), new GBC(0, y++).left(0).top(5).west().pushx());
    ep.add(new JLabel("blabla"), new GBC(0, y++).left(0).west());
    ep.add(new JLabel("blabla"), new GBC(0, y++).left(0).west());
    ep.add(new JLabel("blabla"), new GBC(0, y++).left(0).west());
    ep.add(new JLabel("blabla"), new GBC(0, y++).left(0).west());
    return ep;
  }

  /**
   * Mtodo para testes.
   * 
   * @param args
   */
  public static void main(String[] args) {
    JFrame frame = new JFrame("Teste");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setPreferredSize(new Dimension(350, 300));

    Container contentPane = frame.getRootPane().getContentPane();
    contentPane.setLayout(new GridBagLayout());
    final ExpandablePanelGroup group = new ExpandablePanelGroup();
    JButton buttonExpandAll = group.createExpandAllButton();
    buttonExpandAll.setToolTipText("Expandir todos");
    contentPane.add(buttonExpandAll, new GBC(0, 0).east().insets(10, 10, 0, 10)
      .pushx());

    JButton buttonCollapseAll = group.createCollapseAllButton();
    buttonCollapseAll.setToolTipText("Fechar todos");
    contentPane.add(buttonCollapseAll, new GBC(1, 0).east()
      .insets(10, 0, 0, 10));

    final ExpandablePanel ep1 = makeExpandablePanel("Isto  uma seo");
    contentPane.add(ep1, new GBC(0, 1).northwest().insets(10, 10, 0, 10)
      .horizontal().width(2));

    ep1.setListener(new ActionListener() {

      @Override
      public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
        //        ec1.setTitle("Novo ttulo");
      }
    });

    final ExpandablePanel ep2 =
      new ExpandablePanel("Testando aninhamento", POS, SHOW_SEPARATOR,
        IDENT_CONTENT);

    ExpandablePanel ep3 = makeExpandablePanel("Painel aninhado");
    ep2.add(ep3, new GBC().northwest().top(10).pushxy());

    contentPane.add(ep2, new GBC(0, 2).northwest().insets(15, 10, 0, 10)
      .horizontal().pushy().width(2));

    group.add(ep1);
    group.add(ep2);
    group.setListener(new ActionListener() {

      @Override
      public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
      }
    });

    //    JButton removeAllButton = new JButton(new AbstractAction("Remove All") {
    //
    //      @Override
    //      public void actionPerformed(ActionEvent e) {
    //        ep2.removeAll();
    //        ep2.revalidate();
    //        ep2.add(new JLabel("Novo contedo"), new GBC().northwest().top(5)
    //          .pushx());
    //      }
    //    });
    //
    //    contentPane
    //      .add(removeAllButton, new GBC(0, 3).center().insets(10).width(2));

    frame.pack();
    frame.setVisible(true);
  }

}
