/*
 * $Id$
 */
package tecgraf.javautils.gui.print;

import javax.swing.table.TableModel;

/**
 * Modelo para a tabela que ser impressa. Pede a implementao de mtodos que
 * retornem informaes sobre os nomes de linha e o corner da tabela.
 * 
 */
public interface PrintableTableModel extends TableModel {

  /**
   * Informa se existem ou no nomes de linha.
   * 
   * @return verdadeiro caso existam headers de linha.
   */
  public boolean hasRowNames();

  /**
   * Retorna o texto do nome de linha relacionado  linha passada por parmetro.
   * Retorna valor nulo caso no exista nome para esta linha.
   * 
   * @param rowIndex posio da linha cujo o texto do header ser retornado.
   * @return o nome relacionado  linha ou valor nulo caso no exista header
   *         para esta linha.
   */
  public String getRowName(int rowIndex);

  /**
   * Retorna o texto que est no corner do modelo ou valor nulo caso o corner
   * no exista.
   * 
   * @return texto do corner do modelo ou valor nulo caso no exista corner.
   */
  public String getCornerName();
}
