/*
 * Detalhes da ltima alterao:
 *
 * $Author: oikawa $ $Date: 2014-02-26 16:08:39 -0300 (Wed, 26 Feb 2014) $
 * $Revision: 150399 $
 */
package tecgraf.javautils.gui.wizard.utils.leftdecorations;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.ILeftDecoration;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.WizardException;

/**
 * Representa o painl com as descries dos grupos de passos que o usurio
 * percorrer.
 *
 * @author Tecgraf/PUC-Rio
 */
public class FollowStepLeftDecoration implements ILeftDecoration {
  /**
   * Scrollpane
   */
  private JScrollPane scrollPane;

  /**
   * O painel onde as descries so inseridas efetivamente.
   */
  private JTextPane stepsTextPane;

  /**
   * A lista de grupos de passos de onde as descries so obtidas.
   */
  private List<StepGroup> stepGroupList;

  /**
   * Ttulo
   */
  private String title = "";

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasClosed(Step step) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasConfirmed(Step step, Object result) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGoneNext(Step step, History history) {
    this.showStepsDescription(step);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGonePrevious(Step step, History history) {
    this.showStepsDescription(step);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasHappenedException(Step step, WizardException exception) {
  }

  /**
   * Atualiza o painl para que identifique o passo corrente.
   *
   * @param step O passo corrente.
   */
  private void showStepsDescription(Step step) {
    Iterator<?> stepGroupIterator = this.stepGroupList.iterator();
    StepGroup stepGroup;
    do {
      stepGroup = (StepGroup) stepGroupIterator.next();
    } while (!stepGroup.contains(step));
    showStepsDescription(stepGroup);
  }

  /**
   * Cria os estilos utilizados para exibio da descrio dos grupos de passos.
   */
  private void createStylesOnTextPane() {
    Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle(
      StyleContext.DEFAULT_STYLE);
    Style normalStyle = this.stepsTextPane.addStyle("normalStepStyle",
      defaultStyle);
    StyleConstants.setFontFamily(defaultStyle, "SansSerif");
    Style s = this.stepsTextPane.addStyle("currentStepStyle", normalStyle);
    StyleConstants.setItalic(s, true);
    StyleConstants.setForeground(s, new ColorUIResource(102, 102, 170));
    s = this.stepsTextPane.addStyle("titleStyle", normalStyle);
    StyleConstants.setFontSize(s, 16);
    s = this.stepsTextPane.addStyle("separator", defaultStyle);
    StyleConstants.setComponent(s, new JSeparator(
      javax.swing.SwingConstants.HORIZONTAL));
  }

  /**
   * Atualiza o painl para que identifique o grupo corrente.
   *
   * @param currentGroup O grupo corrente.
   */
  private void showStepsDescription(StepGroup currentGroup) {
    Document doc = this.stepsTextPane.getDocument();
    int caretPosition = 0;
    try {
      doc.remove(0, doc.getLength());
      doc.insertString(doc.getLength(), title + "\n", this.stepsTextPane
        .getStyle("titleStyle"));
      doc.insertString(doc.getLength(), "\n", this.stepsTextPane.getStyle(
        "separator"));
      StringBuffer stepText = new StringBuffer();
      int stepIndex = 1;
      Iterator<?> stepGroupIterator = this.stepGroupList.iterator();
      while (stepGroupIterator.hasNext()) {
        StepGroup stepGroup = (StepGroup) stepGroupIterator.next();
        stepText.setLength(0);
        stepText.append("\n");
        stepText.append(String.valueOf(stepIndex));
        stepText.append(". ");
        stepText.append(stepGroup.getDescription());
        stepText.append("\n");
        if (stepGroup.equals(currentGroup)) {
          caretPosition = doc.getLength();
          doc.insertString(doc.getLength(), stepText.toString(),
            this.stepsTextPane.getStyle("currentStepStyle"));
        }
        else {
          doc.insertString(doc.getLength(), stepText.toString(),
            this.stepsTextPane.getStyle("normalStepStyle"));
        }
        stepIndex++;
      }
      this.stepsTextPane.setCaretPosition(caretPosition);
    }
    catch (BadLocationException exception) {
      IllegalStateException ise = new IllegalStateException();
      ise.initCause(exception);
      throw ise;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasCancelled(Step step) {
  }

  /**
   * Cria o painl de descrio de grupos de passos.
   *
   * @param stepGroupList Uma lista com os grupos de passos.
   */
  public FollowStepLeftDecoration(List<StepGroup> stepGroupList) {
    this.stepGroupList = stepGroupList;
    this.stepsTextPane = new JTextPane();
    this.stepsTextPane.setEditable(false);
    createStylesOnTextPane();

    final int wid = 200;
    final Dimension dim = new Dimension(wid, 300);
    scrollPane.getViewport().add(stepsTextPane);
    scrollPane.setPreferredSize(dim);
    showStepsDescription(this.stepGroupList.get(0));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getComponent() {
    return scrollPane;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSplitPaneNeeded() {
    return true;
  }

  /**
   * COnsulta de ttulo do decorador.
   *
   * @return ttulo
   */
  public final String getTitle() {
    return title;
  }

  /**
   * Ajuste de ttulo do decorador.
   *
   * @param title ttulo
   * @return o prprio objeto.
   */
  public final FollowStepLeftDecoration setTitle(String title) {
    this.title = (title == null ? "" : title);
    return this;
  }
}
