/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.demo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.demo.PingWebSocket;
import tecgraf.javautils.sparkserver.exceptions.JuAuthorizationException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuSparkUtilities;

@Api
public class PingController
extends JuController {
    protected PingController() {
        this.addWebSocket("pingpong", PingWebSocket.class);
        this.addEndpoint(JuVerb.GET, "ping", this.getOk());
        this.addEndpoint(JuVerb.GET, "pong", this.getNotOk());
    }

    @GET
    @Path(value="ping")
    @ApiOperation(value="ping")
    @ApiResponse(code=200, message="Sempre OK!")
    private JuIFunction<String> getOk() {
        return (req, res) -> JuSparkUtilities.setResponseAsText(res, 200, "ok");
    }

    @GET
    @Path(value="pong")
    @ApiOperation(value="pong")
    @ApiResponse(code=404, message="Sempre NOK!")
    private JuIFunction<String> getNotOk() {
        return (req, res) -> {
            throw new JuAuthorizationException("NOT OK as expected!");
        };
    }
}

