/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import spark.Request;
import spark.Response;

public class JuSparkUtilities {
    public static String getRequestParameter(Request request, String parameterName) {
        if (parameterName == null || parameterName.isEmpty()) {
            String err = "parameter name cannot be null.";
            throw new IllegalArgumentException("parameter name cannot be null.");
        }
        return request.params(parameterName);
    }

    public static String getHeaderParameter(Request request, String parameterName) {
        if (parameterName == null || parameterName.isEmpty()) {
            String err = "parameter name cannot be null.";
            throw new IllegalArgumentException("parameter name cannot be null.");
        }
        return request.headers(parameterName);
    }

    public static String getQueryParameter(Request request, String parameterName) {
        if (parameterName == null || parameterName.isEmpty()) {
            String err = "parameter name cannot be null.";
            throw new IllegalArgumentException("parameter name cannot be null.");
        }
        return request.queryParams(parameterName);
    }

    public static <T> String setResponseAsJson(Response response, int statusCode, T data) throws IOException {
        String jsonString = JuSparkUtilities.objectToJson(data);
        response.type("application/json");
        response.body(jsonString);
        response.status(statusCode);
        return jsonString;
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(json, clazz);
    }

    public static JsonNode jsonToNode(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(json);
    }

    public static <T> String objectToJson(T data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        StringWriter sw = new StringWriter();
        mapper.writeValue((Writer)sw, data);
        return sw.toString();
    }

    public static String setResponseAsText(Response response, int statusCode, String message) {
        response.type("text/plain");
        response.body(message);
        response.status(statusCode);
        return message;
    }
}

