/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.entities.EntityInputDialog;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.EntityCategoryDesc;

public class EntityEditAction
extends OpenBusAction<EntityWrapper> {
    public EntityEditAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(EntityEditAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.EDIT;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<EntityCategoryDesc>> task = new BusExplorerTask<List<EntityCategoryDesc>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                this.setResult(EntityEditAction.this.admin.getCategories());
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    EntityInputDialog dialog = new EntityInputDialog(EntityEditAction.this.parentWindow, EntityEditAction.this.getTablePanelComponent(), EntityEditAction.this.admin, (List)this.getResult());
                    dialog.showDialog();
                    EntityWrapper entity = (EntityWrapper)EntityEditAction.this.getTablePanelComponent().getSelectedElement();
                    dialog.setEditionMode(entity);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

