/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Configs;
import demo.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.services.collaboration.easy.EasyCollaboration;
import tecgraf.openbus.services.collaboration.easy.IEasyCollaboration;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumerPOA;

public class OnDemandReceiver
extends JFrame
implements ActionListener {
    private static Connection conn;
    private static OpenBusContext context;
    private static IEasyCollaboration easy;
    private final GridBagConstraints constraints;
    public final Border border = BorderFactory.createLoweredBevelBorder();
    final JButton startButton;
    final JButton stopButton;
    final JLabel receiveStatus;
    private StartTask startTask;
    private StopTask stopTask;

    private JButton makeButton(String caption) {
        JButton b = new JButton(caption);
        b.setActionCommand(caption);
        b.addActionListener(this);
        this.getContentPane().add((Component)b, this.constraints);
        return b;
    }

    public OnDemandReceiver() {
        super(OnDemandReceiver.class.getSimpleName());
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(3, 10, 3, 10);
        this.startButton = this.makeButton("Start");
        this.stopButton = this.makeButton("Stop");
        this.stopButton.setEnabled(false);
        this.receiveStatus = new JLabel();
        this.receiveStatus.setText("Waiting to start...        ");
        this.getContentPane().add((Component)this.receiveStatus, this.constraints);
        easy = new EasyCollaboration(context, new Consumer(), null);
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "Start": {
                this.startTask = new StartTask();
                this.startTask.execute();
                break;
            }
            case "Stop": {
                this.stopTask = new StopTask();
                this.stopTask.execute();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configs configs = Configs.readConfigsFile();
        String entity = configs.user;
        byte[] password = configs.password;
        String host = configs.bushost;
        int port = configs.busport;
        ORB orb = ORBInitializer.initORB((String[])args);
        new Utils.ORBRunThread(orb).start();
        Utils.ShutdownThread shutdown = new Utils.ShutdownThread(orb);
        Runtime.getRuntime().addShutdownHook(shutdown);
        context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        conn = context.createConnection(host, port);
        context.setDefaultConnection(conn);
        conn.loginByPassword(entity, password);
        shutdown.addConnection(conn);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OnDemandReceiver();
            }
        });
    }

    class Consumer
    extends EventConsumerPOA {
        long events = 0L;

        Consumer() {
        }

        @Override
        public void push(Any event) throws ServiceFailure {
            String unit = "th";
            ++this.events;
            if (this.events <= 3L) {
                unit = "rd";
            } else if (this.events == 2L) {
                unit = "nd";
            } else if (this.events == 1L) {
                unit = "st";
            }
            OnDemandReceiver.this.receiveStatus.setText("Received " + this.events + unit + " event!");
        }
    }

    private class StopTask
    extends SwingWorker<Void, Void> {
        private StopTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            easy.exitCollaboration();
            return null;
        }

        @Override
        protected void done() {
            OnDemandReceiver.this.startButton.setEnabled(true);
            OnDemandReceiver.this.stopButton.setEnabled(false);
            OnDemandReceiver.this.receiveStatus.setText("Waiting to start...      ");
        }
    }

    private class StartTask
    extends SwingWorker<Void, Void> {
        private StartTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            easy.startCollaboration();
            return null;
        }

        @Override
        protected void done() {
            OnDemandReceiver.this.startButton.setEnabled(false);
            OnDemandReceiver.this.stopButton.setEnabled(true);
            OnDemandReceiver.this.receiveStatus.setText("Waiting for events...    ");
        }
    }
}

