/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl;

import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;

@Transactional
public abstract class JPARepository<T>
implements Repository<T, JPASpecification<T>> {
    @Override
    public void add(T element) {
        this.getEntityManager().persist(element);
    }

    @Override
    public void remove(T element) {
        this.getEntityManager().remove(element);
    }

    @Override
    public void update(T element) {
        this.getEntityManager().flush();
    }

    private TypedQuery<T> toQuery(JPASpecification<T> specification, Sort ... sorts) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.getType());
        Root root = criteriaQuery.from(this.getType());
        Predicate predicate = specification.toPredicate(root, criteriaBuilder);
        criteriaQuery.where((Expression)predicate);
        for (Sort sort : sorts) {
            if (sort.isAscending()) {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(sort.getAttribute()))});
                continue;
            }
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(sort.getAttribute()))});
        }
        return this.getEntityManager().createQuery(criteriaQuery);
    }

    @Override
    public List<T> find(JPASpecification<T> specification, Sort ... sorts) {
        return this.find(specification, (Integer)null, (Integer)null, sorts);
    }

    @Override
    public List<T> find(JPASpecification<T> specification, Integer maxResult, Sort ... sorts) {
        return this.find(specification, maxResult, (Integer)null, sorts);
    }

    @Override
    public List<T> find(JPASpecification<T> specification, Integer maxResult, Integer offset, Sort ... sorts) {
        TypedQuery<T> query = this.toQuery(specification, sorts);
        if (maxResult != null) {
            if (maxResult <= 0) {
                throw new IllegalArgumentException();
            }
            query.setMaxResults(maxResult.intValue());
        }
        if (offset != null) {
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            query.setFirstResult(offset.intValue());
        }
        return query.getResultList();
    }

    @Override
    public long count(JPASpecification<T> specification) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.getType());
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        Predicate predicate = specification.toPredicate(root, criteriaBuilder);
        criteriaQuery.where((Expression)predicate);
        long result = (Long)this.getEntityManager().createQuery(criteriaQuery).getSingleResult();
        return result;
    }

    @Override
    public T first(JPASpecification<T> specification, Sort ... sorts) {
        return (T)this.toQuery(specification, sorts).setMaxResults(1).getSingleResult();
    }

    public abstract Class<T> getType();

    public abstract EntityManager getEntityManager();
}

