/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import com.github.tennaito.rsql.misc.ArgumentFormatException;
import com.github.tennaito.rsql.misc.DefaultArgumentParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSQLArgumentParser
extends DefaultArgumentParser {
    private static final Logger LOG = Logger.getLogger(RSQLArgumentParser.class.getName());
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy/MM/dd[[' ']['T']HH:mm[:ss][.SSS]]x").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();

    public <T> T parse(String argument, Class<T> type) throws ArgumentFormatException, IllegalArgumentException {
        LOG.log(Level.INFO, "Parsing argument ''{0}'' as type {1}, thread {2}", new Object[]{argument, type.getSimpleName(), Thread.currentThread().getName()});
        if (argument == null || "null".equals(argument.trim().toLowerCase())) {
            return null;
        }
        try {
            if (type.equals(String.class)) {
                return (T)argument;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(argument);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(argument);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, argument);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return (T)Float.valueOf(argument);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return (T)Double.valueOf(argument);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return (T)Long.valueOf(argument);
            }
            if (type.equals(BigDecimal.class)) {
                return (T)new BigDecimal(argument);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ArgumentFormatException(argument, type);
        }
        if (type.equals(Date.class)) {
            return (T)Date.from(this.parseDate(argument));
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)LocalDateTime.ofInstant(this.parseDate(argument), ZoneOffset.UTC);
        }
        try {
            LOG.log(Level.INFO, "Trying to get and invoke valueOf(String s) method on {0}", type);
            Method method = type.getMethod("valueOf", String.class);
            return (T)method.invoke(type, argument);
        }
        catch (InvocationTargetException ex) {
            throw new ArgumentFormatException(argument, type);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.WARNING, "{0} does not have method valueOf(String s) or method is inaccessible", type);
            throw new IllegalArgumentException("Cannot parse argument type " + type);
        }
    }

    private Instant parseDate(String argument) {
        try {
            return ZonedDateTime.parse(argument, this.formatter).toInstant();
        }
        catch (DateTimeParseException ex) {
            throw new ArgumentFormatException(argument, ZonedDateTime.class);
        }
    }
}

