package br.pucrio.tecgraf.soma.serviceapi.persistence.specification;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.AndSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.OrSpecification;

public abstract class JPASpecification<T> implements Specification<T> {

	public abstract Predicate toPredicate(Root<T> root, CriteriaBuilder cb);
	
	public <S extends JPASpecification<T>> JPASpecification<T> and(S other) {
		return new AndSpecification<T>(this, other);
	}
	
	public <S extends JPASpecification<T>> JPASpecification<T> or(S other) {
		return new OrSpecification<T>(this, other);
	}

}
