package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

public class OrSpecification<T> extends JPASpecification<T> {

	private JPASpecification<T> first;
	private JPASpecification<T> second;

	public OrSpecification(JPASpecification<T> first, JPASpecification<T> second) {
		this.first = first;
		this.second = second;
	}

	@Override
	public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
		return cb.or(first.toPredicate(root, cb), second.toPredicate(root, cb));
	}
	
	@Override
	public boolean isSatisfiedBy(T element) {
		return first.isSatisfiedBy(element) || second.isSatisfiedBy(element);
	}

}
