/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.unitofwork.impl;

import br.pucrio.tecgraf.soma.serviceapi.persistence.unitofwork.UnitOfWork;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.SynchronizationType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public abstract class JPAUnitOfWork
implements UnitOfWork,
Closeable {
    private EntityManager entityManager;
    private EntityManagerFactory factory;
    private FlushModeType flushModeType;
    private SynchronizationType synchronizationType;
    private Map<?, ?> map;

    public JPAUnitOfWork(EntityManagerFactory factory) {
        this.factory = factory;
        this.start();
    }

    public void configure(FlushModeType flushModeType, SynchronizationType synchronizationType, Map<?, ?> map) {
        this.flushModeType = flushModeType;
        this.synchronizationType = synchronizationType;
        this.map = map;
    }

    @Override
    public void start() {
        if (this.entityManager != null) {
            throw new IllegalStateException("Unit of work is already started");
        }
        this.entityManager = this.synchronizationType != null || this.map != null ? (this.synchronizationType != null && this.map != null ? this.factory.createEntityManager(this.synchronizationType, this.map) : (this.map != null ? this.factory.createEntityManager(this.map) : this.factory.createEntityManager(this.synchronizationType))) : this.factory.createEntityManager();
        if (this.flushModeType != null) {
            this.entityManager.setFlushMode(this.flushModeType);
        }
        this.entityManager.getTransaction().begin();
    }

    @Override
    public void end() {
        if (!this.entityManager.isOpen()) {
            throw new IllegalStateException("Unit of work was not started");
        }
        try {
            this.entityManager.getTransaction().commit();
        }
        finally {
            this.entityManager.close();
        }
    }

    @Override
    public void cancel() {
        this.entityManager.getTransaction().setRollbackOnly();
    }

    @Override
    public void close() throws IOException {
        this.end();
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }
}

