/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.domain.model.KafkaOffsetInfo;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.KafkaOffsetInfoByIdSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.Specification;
import java.io.IOException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KafkaOffsetInfoService {
    private final Logger logger = LoggerFactory.getLogger(KafkaOffsetInfoService.class);
    private Repository<KafkaOffsetInfo, JPASpecification<KafkaOffsetInfo>> kafkaOffsetInfoRepository;

    @Autowired
    public KafkaOffsetInfoService(Repository<KafkaOffsetInfo, JPASpecification<KafkaOffsetInfo>> kafkaOffsetInfoRepository) {
        this.kafkaOffsetInfoRepository = kafkaOffsetInfoRepository;
    }

    @Transactional(rollbackFor={IOException.class})
    public void updateOffsetInfo(int partitionId, long offset) throws IOException {
        try {
            KafkaOffsetInfo currOffset = (KafkaOffsetInfo)this.kafkaOffsetInfoRepository.first((Specification)new KafkaOffsetInfoByIdSpecification(partitionId));
            if (currOffset != null) {
                this.logger.info("Updating Kafka offset: [partition={}, offset={}].", (Object)partitionId, (Object)offset);
                currOffset.setPartitionOffset(offset);
            } else {
                this.logger.info("Adding Kafka offset: [partition={}, offset={}].", (Object)partitionId, (Object)offset);
                this.kafkaOffsetInfoRepository.add((Object)new KafkaOffsetInfo(partitionId, offset));
            }
        }
        catch (Exception ex) {
            throw new IOException(MessageFormat.format("Error trying to update the Kafka offset for the partition {0}.", partitionId), ex);
        }
    }
}

