package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class ExecutingJobMapper {
  private static final String TYPE_MAP_NAME = "JobExecutingEventToJob";
  private static ExecutingJobMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<JobExecutingEvent, Job> typeMap;

  private ExecutingJobMapper() {
    modelMapper = new ModelMapper();

    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap = modelMapper.createTypeMap(JobExecutingEvent.class, Job.class, TYPE_MAP_NAME);

    typeMap.addMappings(mapper -> mapper.skip(Job::setJobId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGroupId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setProjectId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setAutomaticallyMachineSelection));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSelectedMachines));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcesses));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcessesByMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSubmissionTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDescription));
    typeMap.addMappings(mapper -> mapper.skip(Job::setMultipleExecution));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitCode));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGuiltyNodeId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitStatus));
    typeMap.addMappings(mapper -> mapper.skip(Job::setWallclockTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setCpuTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setEndTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobOwner));
    typeMap.addMappings(mapper -> mapper.skip(Job::setId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobType));
    typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
    typeMap.addMappings(mapper -> mapper.skip(Job::setPriority));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));

    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobExecutingEvent::getTimestamp, Job::setLastModifiedTime));

    modelMapper.validate();
  }

  public static ExecutingJobMapper getInstance() {
    if (instance == null) {
      instance = new ExecutingJobMapper();
    }
    return instance;
  }

  public void map(JobExecutingEvent event, Job job) {
    modelMapper.map(event, job, TYPE_MAP_NAME);
  }
}
