/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.CaseLiteralExpression;
import org.hibernate.jpa.criteria.expression.ExpressionImpl;
import org.hibernate.jpa.criteria.expression.LiteralExpression;

public class SimpleCaseExpression<C, R>
extends ExpressionImpl<R>
implements CriteriaBuilder.SimpleCase<C, R>,
Serializable {
    private Class<R> javaType;
    private final Expression<? extends C> expression;
    private List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private Expression<? extends R> otherwiseResult;

    public SimpleCaseExpression(CriteriaBuilderImpl criteriaBuilder, Class<R> javaType, Expression<? extends C> expression) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
        this.expression = expression;
    }

    @Override
    public Expression<C> getExpression() {
        return this.expression;
    }

    @Override
    public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (Expression<? extends R>)this.buildLiteral(result));
    }

    private LiteralExpression<R> buildLiteral(R result) {
        Class<Object> type = result != null ? result.getClass() : this.getJavaType();
        return new CaseLiteralExpression(this.criteriaBuilder(), type, result);
    }

    @Override
    public CriteriaBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(new LiteralExpression<C>(this.criteriaBuilder(), condition), result);
        this.whenClauses.add(whenClause);
        this.adjustJavaType(result);
        return this;
    }

    private void adjustJavaType(Expression<? extends R> exp) {
        if (this.javaType == null) {
            this.javaType = exp.getJavaType();
        }
    }

    @Override
    public Expression<R> otherwise(R result) {
        return this.otherwise((Expression<? extends R>)this.buildLiteral(result));
    }

    @Override
    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = result;
        this.adjustJavaType(result);
        return this;
    }

    public Expression<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getExpression(), registry);
        for (WhenClause whenClause : this.getWhenClauses()) {
            ParameterContainer.Helper.possibleParameter(whenClause.getResult(), registry);
        }
        ParameterContainer.Helper.possibleParameter(this.getOtherwiseResult(), registry);
    }

    @Override
    public String render(RenderingContext renderingContext) {
        StringBuilder caseExpr = new StringBuilder();
        caseExpr.append("case ").append(((Renderable)((Object)this.getExpression())).render(renderingContext));
        for (WhenClause whenClause : this.getWhenClauses()) {
            caseExpr.append(" when ").append(whenClause.getCondition().render(renderingContext)).append(" then ").append(((Renderable)((Object)whenClause.getResult())).render(renderingContext));
        }
        caseExpr.append(" else ").append(((Renderable)((Object)this.getOtherwiseResult())).render(renderingContext)).append(" end");
        return caseExpr.toString();
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    public class WhenClause {
        private final LiteralExpression<C> condition;
        private final Expression<? extends R> result;

        public WhenClause(LiteralExpression<C> condition, Expression<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }

        public LiteralExpression<C> getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

