/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.core;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.DefaultPersistEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public class JpaPersistEventListener
extends DefaultPersistEventListener
implements CallbackRegistryConsumer {
    private static final Logger log = Logger.getLogger(JpaPersistEventListener.class);
    private CallbackRegistry callbackRegistry;
    public static final CascadingAction PERSIST_SKIPLAZY = new CascadingActions.BaseCascadingAction(){

        @Override
        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            log.trace("Cascading persist to : " + entityName);
            session.persist(entityName, child, (Map)anything);
        }

        @Override
        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingActions.getLoadedElementsIterator((SessionImplementor)session, (CollectionType)collectionType, (Object)collection);
        }

        @Override
        public boolean deleteOrphans() {
            return false;
        }

        @Override
        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST_SKIPLAZY";
        }
    };

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaPersistEventListener() {
    }

    public JpaPersistEventListener(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    @Override
    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, EventSource source) {
        this.callbackRegistry.preCreate(entity);
        return super.saveWithRequestedId(entity, requestedId, entityName, anything, source);
    }

    @Override
    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        this.callbackRegistry.preCreate(entity);
        return super.saveWithGeneratedId(entity, entityName, anything, source, requiresImmediateIdAccess);
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return PERSIST_SKIPLAZY;
    }
}

