/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.metamodel;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.jpa.internal.metamodel.AbstractManagedType;
import org.hibernate.jpa.internal.metamodel.SingularAttributeImpl;

public abstract class AbstractIdentifiableType<X>
extends AbstractManagedType<X>
implements IdentifiableType<X>,
Serializable {
    private final boolean hasIdentifierProperty;
    private final boolean hasIdClass;
    private SingularAttributeImpl<X, ?> id;
    private Set<SingularAttribute<? super X, ?>> idClassAttributes;
    private final boolean isVersioned;
    private SingularAttributeImpl<X, ?> version;

    public AbstractIdentifiableType(Class<X> javaType, String typeName, AbstractIdentifiableType<? super X> superType, boolean hasIdClass, boolean hasIdentifierProperty, boolean versioned) {
        super(javaType, typeName, superType);
        this.hasIdClass = hasIdClass;
        this.hasIdentifierProperty = hasIdentifierProperty;
        this.isVersioned = versioned;
    }

    public boolean hasIdClass() {
        return this.hasIdClass;
    }

    @Override
    public boolean hasSingleIdAttribute() {
        return !this.hasIdClass() && this.hasIdentifierProperty;
    }

    @Override
    public AbstractIdentifiableType<? super X> getSupertype() {
        return (AbstractIdentifiableType)super.getSupertype();
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> javaType) {
        this.ensureNoIdClass();
        SingularAttributeImpl id = this.locateIdAttribute();
        if (id != null) {
            this.checkType(id, javaType);
        }
        return id;
    }

    private void ensureNoIdClass() {
        if (this.hasIdClass()) {
            throw new IllegalArgumentException("Illegal call to IdentifiableType#getId for class [" + this.getTypeName() + "] defined with @IdClass");
        }
    }

    private SingularAttributeImpl locateIdAttribute() {
        SingularAttributeImpl id;
        if (this.id != null) {
            return this.id;
        }
        if (this.getSupertype() != null && (id = ((AbstractIdentifiableType)this.getSupertype()).internalGetId()) != null) {
            return id;
        }
        return null;
    }

    protected SingularAttributeImpl internalGetId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.getSupertype() != null) {
            return ((AbstractIdentifiableType)this.getSupertype()).internalGetId();
        }
        return null;
    }

    private void checkType(SingularAttributeImpl attribute, Class javaType) {
        if (!javaType.isAssignableFrom(attribute.getType().getJavaType())) {
            throw new IllegalArgumentException(String.format("Attribute [%s#%s : %s] not castable to requested type [%s]", this.getTypeName(), attribute.getName(), attribute.getType().getJavaType().getName(), javaType.getName()));
        }
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> javaType) {
        this.ensureNoIdClass();
        if (this.id == null) {
            throw new IllegalArgumentException("The id attribute is not declared on this type [" + this.getTypeName() + "]");
        }
        this.checkType(this.id, javaType);
        return this.id;
    }

    @Override
    public Type<?> getIdType() {
        SingularAttributeImpl id = this.locateIdAttribute();
        if (id != null) {
            return id.getType();
        }
        Set<SingularAttribute<X, ?>> idClassAttributes = this.getIdClassAttributesSafely();
        if (idClassAttributes != null && idClassAttributes.size() == 1) {
            return idClassAttributes.iterator().next().getType();
        }
        return null;
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributesSafely() {
        if (!this.hasIdClass()) {
            return null;
        }
        HashSet attributes = new HashSet();
        this.internalCollectIdClassAttributes(attributes);
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (!this.hasIdClass()) {
            throw new IllegalArgumentException("This class [" + this.getJavaType() + "] does not define an IdClass");
        }
        HashSet attributes = new HashSet();
        this.internalCollectIdClassAttributes(attributes);
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException("Unable to locate IdClass attributes [" + this.getJavaType() + "]");
        }
        return attributes;
    }

    private void internalCollectIdClassAttributes(Set attributes) {
        if (this.idClassAttributes != null) {
            attributes.addAll(this.idClassAttributes);
        } else if (this.getSupertype() != null) {
            super.internalCollectIdClassAttributes(attributes);
        }
    }

    @Override
    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public boolean hasDeclaredVersionAttribute() {
        return this.isVersioned && this.version != null;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> javaType) {
        if (!this.hasVersionAttribute()) {
            return null;
        }
        SingularAttributeImpl version = this.locateVersionAttribute();
        if (version != null) {
            this.checkType(version, javaType);
        }
        return version;
    }

    private SingularAttributeImpl locateVersionAttribute() {
        SingularAttributeImpl version;
        if (this.version != null) {
            return this.version;
        }
        if (this.getSupertype() != null && (version = ((AbstractIdentifiableType)this.getSupertype()).internalGetVersion()) != null) {
            return version;
        }
        return null;
    }

    protected SingularAttributeImpl internalGetVersion() {
        if (this.version != null) {
            return this.version;
        }
        if (this.getSupertype() != null) {
            return ((AbstractIdentifiableType)this.getSupertype()).internalGetVersion();
        }
        return null;
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> javaType) {
        this.checkDeclaredVersion();
        this.checkType(this.version, javaType);
        return this.version;
    }

    private void checkDeclaredVersion() {
        if (this.version == null || this.getSupertype() != null && ((AbstractIdentifiableType)this.getSupertype()).hasVersionAttribute()) {
            throw new IllegalArgumentException("The version attribute is not declared by this type [" + this.getJavaType() + "]");
        }
    }

    public SingularAttribute<X, ?> getDeclaredVersion() {
        this.checkDeclaredVersion();
        return this.version;
    }

    @Override
    public Builder<X> getBuilder() {
        final AbstractManagedType.Builder managedBuilder = super.getBuilder();
        return new Builder<X>(){

            @Override
            public void applyIdAttribute(SingularAttributeImpl<X, ?> idAttribute) {
                AbstractIdentifiableType.this.id = idAttribute;
                managedBuilder.addAttribute(idAttribute);
            }

            @Override
            public void applyIdClassAttributes(Set<SingularAttribute<? super X, ?>> idClassAttributes) {
                for (SingularAttribute idClassAttribute : idClassAttributes) {
                    if (AbstractIdentifiableType.this != idClassAttribute.getDeclaringType()) continue;
                    SingularAttribute declaredAttribute = idClassAttribute;
                    this.addAttribute(declaredAttribute);
                }
                AbstractIdentifiableType.this.idClassAttributes = idClassAttributes;
            }

            @Override
            public void applyVersionAttribute(SingularAttributeImpl<X, ?> versionAttribute) {
                AbstractIdentifiableType.this.version = versionAttribute;
                managedBuilder.addAttribute(versionAttribute);
            }

            @Override
            public void addAttribute(Attribute<X, ?> attribute) {
                managedBuilder.addAttribute(attribute);
            }
        };
    }

    public static interface Builder<X>
    extends AbstractManagedType.Builder<X> {
        public void applyIdAttribute(SingularAttributeImpl<X, ?> var1);

        public void applyIdClassAttributes(Set<SingularAttribute<? super X, ?>> var1);

        public void applyVersionAttribute(SingularAttributeImpl<X, ?> var1);
    }
}

