/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import org.modelmapper.convention.InexactMatcher;
import org.modelmapper.spi.MatchingStrategy;
import org.modelmapper.spi.PropertyNameInfo;
import org.modelmapper.spi.Tokens;

final class LooseMatchingStrategy
implements MatchingStrategy {
    LooseMatchingStrategy() {
    }

    @Override
    public boolean matches(PropertyNameInfo propertyNameInfo) {
        return new Matcher(propertyNameInfo).match();
    }

    @Override
    public boolean isExact() {
        return false;
    }

    public String toString() {
        return "Loose";
    }

    static class Matcher
    extends InexactMatcher {
        Matcher(PropertyNameInfo propertyNameInfo) {
            super(propertyNameInfo);
        }

        boolean match() {
            if (!this.matchLastDestTokens()) {
                return false;
            }
            for (Tokens destTokens : this.propertyNameInfo.getDestinationPropertyTokens()) {
                for (int destTokenIndex = 0; destTokenIndex < destTokens.size(); ++destTokenIndex) {
                    InexactMatcher.DestTokensMatcher matchedTokens = this.matchSourcePropertyName(destTokens, destTokenIndex);
                    if (!matchedTokens.match(this.sourceTokens.size() - 1)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean matchLastDestTokens() {
            Tokens tokens = (Tokens)this.destTokens.get(this.destTokens.size() - 1);
            for (int destTokenIndex = 0; destTokenIndex < tokens.size(); ++destTokenIndex) {
                InexactMatcher.DestTokensMatcher matchedTokens = this.matchSourcePropertyName(tokens, destTokenIndex);
                if (matchedTokens.match()) {
                    return true;
                }
                if (!this.matchSourcePropertyType(tokens.token(destTokenIndex)) && !this.matchSourceClass(tokens.token(destTokenIndex))) continue;
                return true;
            }
            return false;
        }
    }
}

