/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.TypeInfoRegistry;

class PropertyInfoRegistry {
    private static final Map<Integer, Mutator> MUTATOR_CACHE = new ConcurrentHashMap<Integer, Mutator>();
    private static final Map<Integer, Accessor> ACCESSOR_CACHE = new ConcurrentHashMap<Integer, Accessor>();
    private static final Map<Integer, PropertyInfoImpl.FieldPropertyInfo> FIELD_CACHE = new ConcurrentHashMap<Integer, PropertyInfoImpl.FieldPropertyInfo>();

    PropertyInfoRegistry() {
    }

    private static Integer hashCodeFor(Class<?> initialType, String propertyName, Configuration configuration) {
        int result = 31 + initialType.hashCode();
        result = 31 * result + propertyName.hashCode();
        result = 31 * result + configuration.hashCode();
        return result;
    }

    static Accessor accessorFor(Class<?> type, String accessorName, InheritingConfiguration configuration) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, accessorName, configuration);
        if (!ACCESSOR_CACHE.containsKey(hashCode) || !FIELD_CACHE.containsKey(hashCode)) {
            Class<?> uncheckedType = type;
            for (Map.Entry<String, Accessor> entry : TypeInfoRegistry.typeInfoFor(uncheckedType, configuration).getAccessors().entrySet()) {
                if (entry.getValue().getMember() instanceof Method) {
                    PropertyInfoRegistry.accessorFor(type, (Method)entry.getValue().getMember(), configuration, entry.getKey());
                    continue;
                }
                if (!(entry.getValue().getMember() instanceof Field)) continue;
                PropertyInfoRegistry.fieldPropertyFor(type, (Field)entry.getValue().getMember(), configuration, entry.getKey());
            }
        }
        if (ACCESSOR_CACHE.containsKey(hashCode)) {
            return ACCESSOR_CACHE.get(hashCode);
        }
        return FIELD_CACHE.get(hashCode);
    }

    static synchronized Accessor accessorFor(Class<?> type, Method method, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, name, configuration);
        Accessor accessor = ACCESSOR_CACHE.get(hashCode);
        if (accessor == null) {
            accessor = new PropertyInfoImpl.MethodAccessor(type, method, name);
            ACCESSOR_CACHE.put(hashCode, accessor);
        }
        return accessor;
    }

    static synchronized PropertyInfoImpl.FieldPropertyInfo fieldPropertyFor(Class<?> type, Field field, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, name, configuration);
        PropertyInfoImpl.FieldPropertyInfo fieldPropertyInfo = FIELD_CACHE.get(hashCode);
        if (fieldPropertyInfo == null) {
            fieldPropertyInfo = new PropertyInfoImpl.FieldPropertyInfo(type, field, name);
            FIELD_CACHE.put(hashCode, fieldPropertyInfo);
        }
        return fieldPropertyInfo;
    }

    static synchronized Mutator mutatorFor(Class<?> type, String name, InheritingConfiguration configuration) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, name, configuration);
        if (!MUTATOR_CACHE.containsKey(hashCode) || !FIELD_CACHE.containsKey(hashCode)) {
            Class<?> uncheckedType = type;
            for (Map.Entry<String, Mutator> entry : TypeInfoRegistry.typeInfoFor(uncheckedType, configuration).getMutators().entrySet()) {
                if (entry.getValue().getMember() instanceof Method) {
                    PropertyInfoRegistry.mutatorFor(type, (Method)entry.getValue().getMember(), configuration, entry.getKey());
                    continue;
                }
                if (!(entry.getValue().getMember() instanceof Field)) continue;
                PropertyInfoRegistry.fieldPropertyFor(type, (Field)entry.getValue().getMember(), configuration, entry.getKey());
            }
        }
        if (MUTATOR_CACHE.containsKey(hashCode)) {
            return MUTATOR_CACHE.get(hashCode);
        }
        return FIELD_CACHE.get(hashCode);
    }

    static synchronized Mutator mutatorFor(Class<?> type, Method method, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, name, configuration);
        Mutator mutator = MUTATOR_CACHE.get(hashCode);
        if (mutator == null) {
            mutator = new PropertyInfoImpl.MethodMutator(type, method, name);
            MUTATOR_CACHE.put(hashCode, mutator);
        }
        return mutator;
    }
}

