/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.bytebuddy.implementation.bytecode.constant;

import org.modelmapper.internal.asm.MethodVisitor;
import org.modelmapper.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.modelmapper.internal.bytebuddy.implementation.Implementation;
import org.modelmapper.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.modelmapper.internal.bytebuddy.implementation.bytecode.StackSize;
import org.modelmapper.internal.bytebuddy.utility.JavaConstant;

@HashCodeAndEqualsPlugin.Enhance
public class JavaConstantValue
implements StackManipulation {
    private final JavaConstant javaConstant;

    public JavaConstantValue(JavaConstant javaConstant) {
        this.javaConstant = javaConstant;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.javaConstant.asConstantPoolValue());
        return StackSize.SINGLE.toIncreasingSize();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.javaConstant.equals(((JavaConstantValue)object).javaConstant);
    }

    public int hashCode() {
        return 17 * 31 + this.javaConstant.hashCode();
    }
}

