/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.mapping.JpaMetamodelMappingContext;

class JpaMetamodelMappingContextFactoryBean
extends AbstractFactoryBean<JpaMetamodelMappingContext>
implements ApplicationContextAware {
    private ListableBeanFactory beanFactory;

    JpaMetamodelMappingContextFactoryBean() {
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    @Override
    public Class<?> getObjectType() {
        return JpaMetamodelMappingContext.class;
    }

    @Override
    protected JpaMetamodelMappingContext createInstance() throws Exception {
        Set<Metamodel> models = this.getMetamodels();
        HashSet entitySources = new HashSet();
        for (Metamodel metamodel : models) {
            for (ManagedType<?> type : metamodel.getManagedTypes()) {
                Class javaType = type.getJavaType();
                if (javaType == null) continue;
                entitySources.add(javaType);
            }
        }
        JpaMetamodelMappingContext context = new JpaMetamodelMappingContext(models);
        context.setInitialEntitySet(entitySources);
        context.initialize();
        return context;
    }

    private Set<Metamodel> getMetamodels() {
        Collection<EntityManagerFactory> factories = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, EntityManagerFactory.class).values();
        HashSet<Metamodel> metamodels = new HashSet<Metamodel>(factories.size());
        for (EntityManagerFactory emf : factories) {
            metamodels.add(emf.getMetamodel());
        }
        return metamodels;
    }
}

