/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaEntityGraph {
    private static String[] EMPTY_ATTRIBUTE_PATHS = new String[0];
    private final String name;
    private final EntityGraph.EntityGraphType type;
    private final List<String> attributePaths;

    public JpaEntityGraph(EntityGraph entityGraph, String nameFallback) {
        this(StringUtils.hasText(entityGraph.value()) ? entityGraph.value() : nameFallback, entityGraph.type(), entityGraph.attributePaths());
    }

    public JpaEntityGraph(String name, EntityGraph.EntityGraphType type, String[] attributePaths) {
        Assert.hasText(name, "The name of an EntityGraph must not be null or empty!");
        Assert.notNull((Object)type, "FetchGraphType must not be null!");
        this.name = name;
        this.type = type;
        this.attributePaths = Arrays.asList(attributePaths == null ? EMPTY_ATTRIBUTE_PATHS : attributePaths);
    }

    public String getName() {
        return this.name;
    }

    public EntityGraph.EntityGraphType getType() {
        return this.type;
    }

    public List<String> getAttributePaths() {
        return this.attributePaths;
    }

    public boolean isAdHocEntityGraph() {
        return !this.attributePaths.isEmpty();
    }

    public String toString() {
        return "JpaEntityGraph [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", attributePaths=" + this.attributePaths.toString() + "]";
    }
}

