/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.ClassUtils;

public class BeanDefinitionUtils {
    private static final String JNDI_OBJECT_FACTORY_BEAN = "org.springframework.jndi.JndiObjectFactoryBean";
    private static final List<Class<?>> EMF_TYPES;

    public static Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, EntityManagerFactory.class, true, false)));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, AbstractEntityManagerFactoryBean.class, true, false)) {
            names.add(BeanFactoryUtils.transformedBeanName(factoryBeanName));
        }
        return names;
    }

    public static Collection<EntityManagerFactoryBeanDefinition> getEntityManagerFactoryBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<EntityManagerFactoryBeanDefinition> definitions = new ArrayList<EntityManagerFactoryBeanDefinition>();
        for (Class<?> type : EMF_TYPES) {
            for (String name : beanFactory.getBeanNamesForType(type, true, false)) {
                BeanDefinitionUtils.registerEntityManagerFactoryBeanDefinition(BeanFactoryUtils.transformedBeanName(name), beanFactory, definitions);
            }
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
            definitions.addAll(BeanDefinitionUtils.getEntityManagerFactoryBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory));
        }
        return definitions;
    }

    private static void registerEntityManagerFactoryBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory, List<EntityManagerFactoryBeanDefinition> definitions) {
        BeanDefinition definition = beanFactory.getBeanDefinition(name);
        if (JNDI_OBJECT_FACTORY_BEAN.equals(definition.getBeanClassName()) ? !EntityManagerFactory.class.getName().equals(definition.getPropertyValues().get("expectedType")) : beanFactory.getType(name) == null || !EntityManagerFactory.class.isAssignableFrom(beanFactory.getType(name))) {
            return;
        }
        definitions.add(new EntityManagerFactoryBeanDefinition(name, beanFactory));
    }

    public static BeanDefinition getBeanDefinition(String name, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(name);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return BeanDefinitionUtils.getBeanDefinition(name, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw o_O;
        }
    }

    static {
        ArrayList<Class<JndiObjectFactoryBean>> types = new ArrayList<Class<JndiObjectFactoryBean>>();
        types.add(EntityManagerFactory.class);
        types.add(AbstractEntityManagerFactoryBean.class);
        if (ClassUtils.isPresent(JNDI_OBJECT_FACTORY_BEAN, ClassUtils.getDefaultClassLoader())) {
            types.add(JndiObjectFactoryBean.class);
        }
        EMF_TYPES = Collections.unmodifiableList(types);
    }

    public static class EntityManagerFactoryBeanDefinition {
        private final String beanName;
        private final ConfigurableListableBeanFactory beanFactory;

        public EntityManagerFactoryBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            this.beanName = beanName;
            this.beanFactory = beanFactory;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        public BeanDefinition getBeanDefinition() {
            return this.beanFactory.getBeanDefinition(this.beanName);
        }
    }
}

