/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.data.repository.query.spi.EvaluationContextExtension;
import org.springframework.data.repository.query.spi.Function;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class EvaluationContextExtensionInformation {
    private final ExtensionTypeInformation extensionTypeInformation;
    private final RootObjectInformation rootObjectInformation;

    public EvaluationContextExtensionInformation(Class<? extends EvaluationContextExtension> type) {
        Assert.notNull(type, "Extension type must not be null!");
        Class<?> rootObjectType = EvaluationContextExtensionInformation.getRootObjectMethod(type).getReturnType();
        this.rootObjectInformation = Object.class.equals(rootObjectType) ? null : new RootObjectInformation(rootObjectType);
        this.extensionTypeInformation = new ExtensionTypeInformation(type);
    }

    public ExtensionTypeInformation getExtensionTypeInformation() {
        return this.extensionTypeInformation;
    }

    public RootObjectInformation getRootObjectInformation(Object target) {
        return target == null ? RootObjectInformation.NONE : (this.rootObjectInformation == null ? new RootObjectInformation(target.getClass()) : this.rootObjectInformation);
    }

    private static Method getRootObjectMethod(Class<?> type) {
        try {
            return type.getMethod("getRootObject", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, Object> discoverDeclaredProperties(Class<?> type, ReflectionUtils.FieldFilter filter) {
        final HashMap map = new HashMap();
        ReflectionUtils.doWithFields(type, new ReflectionUtils.FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalAccessException {
                map.put(field.getName(), field.get(null));
            }
        }, filter);
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    static class RootObjectInformation {
        private static final RootObjectInformation NONE = new RootObjectInformation(Object.class);
        private final Map<String, Method> accessors;
        private final Collection<Method> methods;
        private final Collection<Field> fields;

        public RootObjectInformation(Class<?> type) {
            Assert.notNull(type, "Type must not be null!");
            this.accessors = new HashMap<String, Method>();
            this.methods = new HashSet<Method>();
            this.fields = new ArrayList<Field>();
            if (Object.class.equals(type)) {
                return;
            }
            final PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(type);
            ReflectionUtils.doWithMethods(type, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) {
                    RootObjectInformation.this.methods.add(method);
                    for (PropertyDescriptor descriptor : descriptors) {
                        if (!method.equals(descriptor.getReadMethod())) continue;
                        RootObjectInformation.this.accessors.put(descriptor.getName(), method);
                    }
                }
            }, ExtensionTypeInformation.PublicMethodAndFieldFilter.NON_STATIC);
            ReflectionUtils.doWithFields(type, new ReflectionUtils.FieldCallback(){

                @Override
                public void doWith(Field field) {
                    RootObjectInformation.this.fields.add(field);
                }
            }, ExtensionTypeInformation.PublicMethodAndFieldFilter.NON_STATIC);
        }

        public Map<String, Function> getFunctions(Object target) {
            if (target == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Function> functions = new HashMap<String, Function>(this.methods.size());
            for (Method method : this.methods) {
                functions.put(method.getName(), new Function(method, target));
            }
            return Collections.unmodifiableMap(functions);
        }

        public Map<String, Object> getProperties(Object target) {
            if (target == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (Map.Entry<String, Method> method : this.accessors.entrySet()) {
                properties.put(method.getKey(), new Function(method.getValue(), target));
            }
            for (Field field : this.fields) {
                properties.put(field.getName(), ReflectionUtils.getField(field, target));
            }
            return Collections.unmodifiableMap(properties);
        }
    }

    public static class ExtensionTypeInformation {
        private final Map<String, Object> properties;
        private final Map<String, Function> functions;

        public ExtensionTypeInformation(Class<? extends EvaluationContextExtension> type) {
            Assert.notNull(type, "Extension type must not be null!");
            this.functions = ExtensionTypeInformation.discoverDeclaredFunctions(type);
            this.properties = EvaluationContextExtensionInformation.discoverDeclaredProperties(type, PublicMethodAndFieldFilter.STATIC);
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public Map<String, Function> getFunctions() {
            return this.functions;
        }

        private static Map<String, Function> discoverDeclaredFunctions(Class<?> type) {
            final HashMap map = new HashMap();
            ReflectionUtils.doWithMethods(type, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                        map.put(method.getName(), new Function(method, null));
                    }
                }
            });
            return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        }

        static class PublicMethodAndFieldFilter
        implements ReflectionUtils.MethodFilter,
        ReflectionUtils.FieldFilter {
            public static final PublicMethodAndFieldFilter STATIC = new PublicMethodAndFieldFilter(true);
            public static final PublicMethodAndFieldFilter NON_STATIC = new PublicMethodAndFieldFilter(false);
            private final boolean staticOnly;

            public PublicMethodAndFieldFilter(boolean forStatic) {
                this.staticOnly = forStatic;
            }

            @Override
            public boolean matches(Method method) {
                if (ReflectionUtils.isObjectMethod(method)) {
                    return false;
                }
                boolean methodStatic = Modifier.isStatic(method.getModifiers());
                boolean staticMatch = this.staticOnly ? methodStatic : !methodStatic;
                return Modifier.isPublic(method.getModifiers()) && staticMatch;
            }

            @Override
            public boolean matches(Field field) {
                boolean fieldStatic = Modifier.isStatic(field.getModifiers());
                boolean staticMatch = this.staticOnly ? fieldStatic : !fieldStatic;
                return Modifier.isPublic(field.getModifiers()) && staticMatch;
            }
        }
    }
}

